/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.errorcode;

import com.xforceplus.tower.common.errorcode.TowerErrorCode;

public enum BasicErrorCode implements TowerErrorCode
{
    SystemError(100001, "\u7cfb\u7edf\u9519\u8bef"),
    NotAuthError(100401, "\u672a\u901a\u8fc7\u7528\u6237\u4e2d\u5fc3\u7f51\u5173\u8c03\u7528\u9519\u8bef"),
    ParameterError(100403, "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");

    private int code;
    private String msg;

    private BasicErrorCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public static TowerErrorCode get(int code) {
        BasicErrorCode[] basicErrorCodeArray = BasicErrorCode.values();
        int n = basicErrorCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicErrorCode i = basicErrorCodeArray[n2];
            if (i.getCode() == code) {
                return i;
            }
            ++n2;
        }
        return SystemError;
    }

    public static BasicErrorCode valueOf(String string) {
        return Enum.valueOf(BasicErrorCode.class, string);
    }
}

