/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.filter;

import com.xforceplus.tower.common.filter.TowerHttpServletResponseWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TowerLogFilter
implements Filter {
    Logger logger = LoggerFactory.getLogger(TowerLogFilter.class);
    private List<String> ignorePath = new ArrayList<String>(){
        {
            this.add("/actuator");
            this.add("/webjars");
            this.add("/health");
            this.add("/prometheus");
            this.add("/api-docs");
            this.add("/swagger");
            this.add("/error");
            this.add("favicon.ico");
        }
    };

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        TowerHttpServletResponseWrapper mResp = new TowerHttpServletResponseWrapper(resp);
        boolean isIgnorePath = this.ignoreUrl(req);
        String uuid = UUID.randomUUID().toString();
        if (!isIgnorePath) {
            this.logger.info(String.format("[%s]received request [url = %s, header = %s, cookies = %s]", uuid, req.getRequestURL(), this.getRequestHeaders(req), this.getRequestCookies(req)));
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)mResp);
        byte[] bytes = mResp.getBytes();
        if (!isIgnorePath) {
            this.logger.info(String.format("[%s]response data = %s", uuid, bytes == null ? null : new String(bytes, "utf-8")));
        }
        if (((HttpServletResponse)response).getStatus() == 200) {
            resp.getOutputStream().write(bytes);
        }
    }

    private boolean ignoreUrl(HttpServletRequest req) {
        String url = req.getRequestURI();
        for (String path : this.ignorePath) {
            if (!url.toUpperCase().contains(path.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private String getRequestCookies(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder(200);
        if (req == null) {
            return null;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookie != null) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.format("%s=%s", cookie.getName(), cookie.getValue()));
            }
            ++n2;
        }
        return sb.toString();
    }

    private String getRequestHeaders(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder(150);
        if (req == null) {
            return null;
        }
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            String name = (String)names.nextElement();
            sb.append(String.format("%s: %s", name, req.getHeader(name)));
        }
        return sb.toString();
    }

    public void destroy() {
    }
}

