/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.interceptor;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CommonCustomMetricsInterceptor
extends HandlerInterceptorAdapter {
    AtomicInteger atomicInteger = new AtomicInteger(37);
    private static final String APP_ID = "appId";
    private static final String TENANT_ID = "tenantId";

    @RequestMapping(value={"/{tenantId}"})
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String requestUri = request.getRequestURI();
        String method = request.getMethod();
        int status = response.getStatus();
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map map = (Map)webRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        String appId = StringUtils.isBlank((String)request.getParameter(APP_ID)) ? "" : request.getParameter(APP_ID);
        String tenantId = map == null || StringUtils.isBlank((String)((String)map.get(TENANT_ID))) ? "" : (String)map.get(TENANT_ID);
        Counter requestCounter = Metrics.counter((String)"tower.custom.common.http.requests.total", (String[])new String[]{APP_ID, appId, TENANT_ID, tenantId, "path", requestUri, "method", method, "status", String.valueOf(status)});
        requestCounter.increment();
        super.afterCompletion(request, response, handler, ex);
    }
}

