/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.token;

import com.xforceplus.tower.common.token.UserCenterToken;
import com.xforceplus.tower.common.token.UserCenterTokenResponse;
import com.xforceplus.tower.utils.JsonUtil;
import com.xforceplus.tower.utils.net.HttpClientUtil;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UserCenter {
    private static final Logger log = LoggerFactory.getLogger(UserCenter.class);
    @Value(value="${tower.userCenter.url:}")
    private String url;
    @Value(value="${tower.userCenter.clientId:}")
    private String clientId;
    @Value(value="${tower.userCenter.secret:}")
    private String secret;
    @Value(value="${tower.userCenter.token.expiry:1}")
    private Integer expiry;
    private static UserCenterToken tokenCache = new UserCenterToken();
    private static final Integer ONE_MINUTE = 60000;

    public String getToken() {
        if (StringUtils.isBlank((String)tokenCache.getToken()) || System.currentTimeMillis() - tokenCache.getTimestamp() > (long)(this.expiry * ONE_MINUTE)) {
            this.getUserCenterToken();
            log.info("tokenCache.timestamp:{}", (Object)tokenCache.getTimestamp());
        }
        return tokenCache.getToken();
    }

    private void getUserCenterToken() {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("clientId", this.clientId);
        param.put("secret", this.secret);
        String tokenJson = HttpClientUtil.doPostJson((String)this.url, (String)JsonUtil.toJson(param));
        UserCenterTokenResponse userCenterTokenResponse = (UserCenterTokenResponse)JsonUtil.toBean((String)tokenJson, UserCenterTokenResponse.class);
        tokenCache.setToken(userCenterTokenResponse.getData());
        tokenCache.setTimestamp(System.currentTimeMillis());
    }
}

