/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.common.track.properties.provider.factory;

import com.xforceplus.tower.common.track.config.XplatServiceBootstrap;
import com.xforceplus.tower.common.track.properties.provider.XplatAppIdProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatAppVersionProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatProviderManager;
import com.xforceplus.tower.common.track.properties.provider.impl.XplatNullProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFactoryXplatProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFactoryXplatProvider.class);
    private static Object lock = new Object();
    private static volatile XplatProviderManager s_manager;

    static {
        AbstractFactoryXplatProvider.getManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XplatProviderManager getManager() {
        try {
            if (s_manager == null) {
                Object var0 = lock;
                Object object = lock;
                synchronized (object) {
                    if (s_manager == null) {
                        s_manager = XplatServiceBootstrap.loadFirst(XplatProviderManager.class);
                    }
                }
            }
            return s_manager;
        }
        catch (Throwable var3) {
            s_manager = new XplatNullProviderManager();
            logger.error("Initialize ProviderManager failed.", var3);
            return s_manager;
        }
    }

    public static String getProperty(String name, String defaultValue) {
        try {
            return AbstractFactoryXplatProvider.getManager().getProperty(name, defaultValue);
        }
        catch (Throwable var3) {
            logger.error("getProperty for {} failed.", (Object)name, (Object)var3);
            return defaultValue;
        }
    }

    public static XplatAppIdProvider app() {
        try {
            return (XplatAppIdProvider)AbstractFactoryXplatProvider.getManager().provider(XplatAppIdProvider.class);
        }
        catch (Exception var1) {
            logger.error("Initialize ApplicationProvider failed.", (Throwable)var1);
            return XplatNullProviderManager.PROVIDER;
        }
    }

    public static XplatAppVersionProvider version() {
        try {
            return (XplatAppVersionProvider)AbstractFactoryXplatProvider.getManager().provider(XplatAppVersionProvider.class);
        }
        catch (Exception var1) {
            logger.error("Initialize ApplicationProvider failed.", (Throwable)var1);
            return XplatNullProviderManager.PROVIDER;
        }
    }
}

