/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.filter;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.*;
/**
 * http封装类
 * @ClassName: TowerHttpServletResponseWrapper. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:50:41 
 *
 */
public class TowerHttpServletResponseWrapper extends HttpServletResponseWrapper {

	private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
	private HttpServletResponse response;
	private PrintWriter pwrite;

	public TowerHttpServletResponseWrapper(HttpServletResponse response) {
		super(response);
		this.response = response;
	}

	@Override
	public ServletOutputStream getOutputStream() {
		return new MyServletOutputStream(bytes); // 将数据写到 byte 中
	}

	/**
	 * 重写父类的 getWriter() 方法，将响应数据缓存在 PrintWriter 中
	 */
	@Override
	public PrintWriter getWriter() {
		try {
			pwrite = new PrintWriter(new OutputStreamWriter(bytes, "utf-8"));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return pwrite;
	}

	/**
	 * 获取缓存在 PrintWriter 中的响应数据
	 * 
	 * @return
	 */
	public byte[] getBytes() {
		if (null != pwrite) {
			pwrite.close();
			return bytes.toByteArray();
		}

		if (null != bytes) {
			try {
				bytes.flush();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return bytes.toByteArray();
	}

	class MyServletOutputStream extends ServletOutputStream {
		private ByteArrayOutputStream ostream;

		public MyServletOutputStream(ByteArrayOutputStream ostream) {
			this.ostream = ostream;
		}

		@Override
		public void write(int b) throws IOException {
			ostream.write(b); // 将数据写到 stream 中
		}

		@Override
		public boolean isReady() {
			return false;
		}

		@Override
		public void setWriteListener(WriteListener writeListener) {

		}
	}
}
