/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 公共入参/出参日志打印
 * 
 * @ClassName: TowerLogFilter.
 * @Description: TODO
 * @author zhaochao
 * @date 2019年10月10日 上午10:37:27
 *
 */
public class TowerLogFilter implements Filter {

	Logger logger = LoggerFactory.getLogger(TowerLogFilter.class);

	private List<String> ignorePath = new ArrayList<String>() {
		{
			add("/actuator");
			add("/webjars");
			add("/health");
			add("/prometheus");
			add("/api-docs");
			add("/swagger");
			add("/error");
			add("favicon.ico");
		}
	};

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {

	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse resp = (HttpServletResponse) response;

		TowerHttpServletResponseWrapper mResp = new TowerHttpServletResponseWrapper(resp); // 包装响应对象 resp 并缓存响应数据

		boolean isIgnorePath = ignoreUrl(req);
		String uuid = UUID.randomUUID().toString();
		if (!isIgnorePath) {
			logger.info(String.format("[%s]received request [url = %s, header = %s, cookies = %s]", uuid,
					req.getRequestURL(), getRequestHeaders(req), getRequestCookies(req)));
		}

		chain.doFilter(req, mResp);

		byte[] bytes = mResp.getBytes(); // 获取缓存的响应数据
		if (!isIgnorePath) {
			logger.info(
					String.format("[%s]response data = %s", uuid, bytes == null ? null : new String(bytes, "utf-8")));
		}
		if (((HttpServletResponse) response).getStatus() == HttpStatus.SC_OK) {
			resp.getOutputStream().write(bytes);
		}
	}

	private boolean ignoreUrl(HttpServletRequest req) {
		String url = req.getRequestURI();
		for (String path : ignorePath) {
			if (url.toUpperCase().contains(path.toUpperCase())) {
				return true;
			}
		}
		return false;
	}

	private String getRequestCookies(HttpServletRequest req) {
		StringBuilder sb = new StringBuilder(200);
		if (req == null) {
			return null;
		}
		Cookie[] cookies = req.getCookies();
		if (cookies == null) {
			return null;
		}
		for (Cookie cookie : cookies) {
			if (cookie == null) {
				continue;
			}
			if (sb.length() > 0) {
				sb.append("&");
			}
			sb.append(String.format("%s=%s", cookie.getName(), cookie.getValue()));
		}
		return sb.toString();
	}

	private String getRequestHeaders(HttpServletRequest req) {
		StringBuilder sb = new StringBuilder(150);
		if (req == null) {
			return null;
		}
		Enumeration<String> names = req.getHeaderNames();
		while (names.hasMoreElements()) {
			if (sb.length() > 0) {
				sb.append("&");
			}

			String name = names.nextElement();
			sb.append(String.format("%s: %s", name, req.getHeader(name)));
		}
		return sb.toString();
	}

	@Override
	public void destroy() {

	}

}
