/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.xforceplus.tower.common.errorcode.BasicErrorCode;
import com.xforceplus.tower.common.response.Response;
import com.xforceplus.tower.utils.net.SendMsgUtil;

/**
 * 所有下沉服务需走用户中心网关验证
 * 
 * @ClassName: ValidateUserCenterHandlerInterceptor.
 * @Description: TODO
 * @author zhaochao
 * @date 2019年10月16日 上午11:13:07
 *
 */
public class ValidateUserCenterHandlerInterceptor extends HandlerInterceptorAdapter {

	private Logger logger = LoggerFactory.getLogger(ValidateUserCenterHandlerInterceptor.class);

	@Value("${tower.validate.usercenter.allowedUrl:}")
	private String allowedUrl;

	@Value("${tower.validate.usercenter.enabled:true}")
	private Boolean validateEnabled;

	private static String[] userCenterHosts = { "tenant-gateway.41-tcenter-prod", "paas.xforceplus.com",
			"tenant-gateway.41-tenant-center", "tenant-gateway.41-tenant-sit", "paas-t.xforceplus.com", "paas-s.xforceplus.com","ilife.xforceplus.com","saas.xforceplus.com","saas-i.xforceplus.com","saas-t.xforceplus.com",
			"invtest2-fp.fiberhome.com","inv-fp.fiberhome.com"};

	private static String[] ignorePath = { "/actuator", "/webjars", "/health", "/prometheus", "/api-docs", "/swagger",
			"/error", "favicon.ico" };

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		
		// 启用是否校验或设置白名单，说明不进行服务拦截
		if (!validateEnabled || validateUrl(request.getServletPath(), ignorePath)
				|| validateUrl(request.getServletPath(), allowedUrl.split(","))) {
			return super.preHandle(request, response, handler);
		}
		// 网关暂无提供签名信息，通过X-Forwarded-Host判断
		String xForwardedHost = request.getHeader("X-Forwarded-Host");

		logger.info("request.getServletPath()==>{} xForwardedHost==>{}", request.getServletPath(), xForwardedHost);

		if (StringUtils.isBlank(xForwardedHost) || !validateUrl(xForwardedHost, userCenterHosts)) {
			response.setStatus(HttpStatus.UNAUTHORIZED.value());

			Response returnResponse = new Response<>();
			returnResponse.setCode(BasicErrorCode.NotAuthError.getCode());
			returnResponse.setMessage(BasicErrorCode.NotAuthError.getMsg());

			SendMsgUtil.sendJsonMessage(response, returnResponse);

			return false;

		}

		return super.preHandle(request, response, handler);
	}

	/**
	 * 验证Url白名单
	 * 
	 * @param servletPath
	 * @param allowedUrl
	 * @return
	 */
	private static Boolean validateUrl(String path, String[] allowedUrls) {

		if (allowedUrls.length <= 0) {
			return false;
		}

		for (String url : allowedUrls) {
			if (!StringUtils.isBlank(url) && path.toLowerCase().contains(url.toLowerCase())) {
				return true;
			}
		}
		return false;
	}

	public static void main(String[] args) {
		System.out.println(validateUrl("/swagger-ui.html", ignorePath));
	}

}