/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;

import com.xforceplus.tower.common.errorcode.BasicErrorCode;
import com.xforceplus.tower.common.errorcode.TowerErrorCode;
/**
 * 公共返回类
 * @ClassName: Response. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:51:33 
 * 
 * @param <T>
 */
@ApiModel(value = "请求返回数据")
public class Response<T> implements Serializable {
	/**
	 * @Fields serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "错误码")
	public int code;
	@ApiModelProperty(value = "错误信息")
	public String message;
	@ApiModelProperty(value = "业务数据")
	public T result;

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	/**
	 * getter.
	 * 
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * setter.
	 * 
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * getter.
	 * 
	 * @return the result
	 */
	public T getResult() {
		return result;
	}

	/**
	 * setter.
	 * 
	 * @param result the result to set
	 */
	public void setResult(T result) {
		this.result = result;
	}

	public static Response success(String message, Object result) {
		Response rtn = new Response();
		rtn.setMessage(message);
		rtn.setResult(result);
		return rtn;
	}

	public static Response success(Object result) {
		Response rtn = new Response();
		rtn.setResult(result);
		return rtn;
	}

	public static Response fail() {
		Response rtn = new Response();
		rtn.setCode(BasicErrorCode.SystemError.getCode());
		rtn.setMessage(BasicErrorCode.SystemError.getMsg());
		return rtn;
	}

	public static Response fail(TowerErrorCode errorCode) {
		if (errorCode == null) {
			return null;
		}
		Response rtn = new Response();
		rtn.setCode(errorCode.getCode());
		rtn.setMessage(errorCode.getMsg());
		return rtn;
	}

	public static Response fail(TowerErrorCode errorCode, Object result) {
		if (errorCode == null) {
			return null;
		}
		Response rtn = new Response();
		rtn.setCode(errorCode.getCode());
		rtn.setMessage(errorCode.getMsg());
		rtn.setResult(result);
		return rtn;
	}

	/**
	 * 自定义message chao-zhao
	 * 
	 * @param errorCode
	 * @param msg
	 * @return
	 */
	public static Response failOfMsg(TowerErrorCode errorCode, String msg) {
		if (errorCode == null) {
			return null;
		}
		Response rtn = new Response();
		rtn.setCode(errorCode.getCode());
		rtn.setMessage(errorCode.getMsg());
		if (StringUtils.isNotBlank(msg)) {
			rtn.setMessage(msg);
		}
		return rtn;
	}

	@Override
	public String toString() {
		return "Response{" + "code='" + code + '\'' + ", message='" + message + '\'' + ", result=" + result + '}';
	}
}
