/**
 * Copyright (C) 2015-2019 www.xforceplus.com Inc. All rights reserved.
 * 注意：本内容仅限于上海云砺信息科技有限公司内部传阅，禁止外泄以及用于其他的商业目.
 */
package com.xforceplus.tower.common.token;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.xforceplus.tower.utils.JsonUtil;
import com.xforceplus.tower.utils.coder.EncodeUtil;
import com.xforceplus.tower.utils.net.HttpClientUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户中心服务
 * 
 * @ClassName: UserCenter.
 * @Description: TODO
 * @author zhaochao
 * @date 2019年10月25日 下午6:25:59
 * 
 */
@Component
@Slf4j
public class UserCenter {

	@Value("${tower.userCenter.url:}")
	private String url;

	@Value("${tower.userCenter.clientId:}")
	private String clientId;

	@Value("${tower.userCenter.secret:}")
	private String secret;

	@Value("${tower.userCenter.token.expiry:1}")
	private Integer expiry;

	private static UserCenterToken tokenCache = new UserCenterToken();

	/**
	 * 1分钟=60秒*1000毫秒=60000毫秒
	 */
	private static final Integer ONE_MINUTE = 60000;

	/**
	 * 获取token信息
	 * 
	 * @return String
	 */
	public String getToken() {

		if (StringUtils.isBlank(tokenCache.getToken())
				|| System.currentTimeMillis() - tokenCache.getTimestamp() > expiry * ONE_MINUTE) {

			getUserCenterToken();

			log.info("tokenCache.timestamp:{}", tokenCache.getTimestamp());

		}

		return tokenCache.getToken();
	}

	/**
	 * 获得用户中心token
	 */
	private void getUserCenterToken() {
		Map<String, String> param = new HashMap<String, String>(2);
		param.put("clientId", clientId);
		param.put("secret", secret);

		String tokenJson = HttpClientUtil.doPostJson(url, JsonUtil.toJson(param));
		UserCenterTokenResponse userCenterTokenResponse = JsonUtil.toBean(tokenJson, UserCenterTokenResponse.class);

		tokenCache.setToken(userCenterTokenResponse.getData());
		tokenCache.setTimestamp(System.currentTimeMillis());
	}

}
