package com.xforceplus.tower.common.track.properties.provider.factory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xforceplus.tower.common.track.config.XplatServiceBootstrap;
import com.xforceplus.tower.common.track.properties.provider.XplatAppIdProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatAppVersionProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatProviderManager;
import com.xforceplus.tower.common.track.properties.provider.impl.XplatNullProviderManager;
/**
 * 链路追踪抽象类
 * @ClassName: AbstractFactoryXplatProvider. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:54:06 
 *
 */
public abstract class AbstractFactoryXplatProvider {
	private static final Logger logger = LoggerFactory.getLogger(AbstractFactoryXplatProvider.class);
	private static Object lock = new Object();
	private static volatile XplatProviderManager s_manager;

	public AbstractFactoryXplatProvider() {
	}

	private static XplatProviderManager getManager() {
		try {
			if (s_manager == null) {
				Object var0 = lock;
				synchronized (lock) {
					if (s_manager == null) {
						s_manager = (XplatProviderManager) XplatServiceBootstrap.loadFirst(XplatProviderManager.class);
					}
				}
			}

			return s_manager;
		} catch (Throwable var3) {
			s_manager = new XplatNullProviderManager();
			logger.error("Initialize ProviderManager failed.", var3);
			return s_manager;
		}
	}

	public static String getProperty(String name, String defaultValue) {
		try {
			return getManager().getProperty(name, defaultValue);
		} catch (Throwable var3) {
			logger.error("getProperty for {} failed.", name, var3);
			return defaultValue;
		}
	}

	public static XplatAppIdProvider app() {
		try {
			return (XplatAppIdProvider) getManager().provider(XplatAppIdProvider.class);
		} catch (Exception var1) {
			logger.error("Initialize ApplicationProvider failed.", var1);
			return XplatNullProviderManager.PROVIDER;
		}
	}

	public static XplatAppVersionProvider version() {
		try {
			return (XplatAppVersionProvider) getManager().provider(XplatAppVersionProvider.class);
		} catch (Exception var1) {
			logger.error("Initialize ApplicationProvider failed.", var1);
			return XplatNullProviderManager.PROVIDER;
		}
	}

	static {
		getManager();
	}
}
