package com.xforceplus.tower.common.track.properties.provider.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xforceplus.tower.common.track.properties.provider.XplatProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatProviderManager;
/**
 * 链路追踪抽象类
 * @ClassName: AbstractDefaultXplatProviderManager. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:54:21 
 *
 */
public class AbstractDefaultXplatProviderManager implements XplatProviderManager {
	private static final Logger logger = LoggerFactory.getLogger(AbstractDefaultXplatProviderManager.class);
	private Map<Class<? extends XplatProvider>, XplatProvider> mProviders = new LinkedHashMap();

	public AbstractDefaultXplatProviderManager() {
		XplatProvider applicationProvider = new DefaultXplatAppIdProvider();
		applicationProvider.initialize();
		this.register(applicationProvider);

		DefaultXplatAppVersionProvider defaultXplatAppVersionProvider = new DefaultXplatAppVersionProvider();
		defaultXplatAppVersionProvider.initialize();
		this.register(defaultXplatAppVersionProvider);
	}

	public synchronized void register(XplatProvider provider) {
		this.mProviders.put(provider.getType(), provider);
	}

	@Override
	public <T extends XplatProvider> XplatProvider provider(Class<T> clazz) {
		XplatProvider provider = this.mProviders.get(clazz);
		if (provider != null) {
			return provider;
		} else {
			logger.error(
					"No provider [{}] found in DefaultXplatProviderManager, please make sure it is registered in DefaultProviderManager ",
					clazz.getName());
			return XplatNullProviderManager.PROVIDER;
		}
	}

	@Override
	public String getProperty(String name, String defaultValue) {
		Iterator var3 = this.mProviders.values().iterator();

		String value;
		do {
			if (!var3.hasNext()) {
				return defaultValue;
			}

			XplatProvider provider = (XplatProvider) var3.next();
			value = provider.getProperty(name, (String) null);
		} while (value == null);

		return value;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(512);
		if (null != this.mProviders) {
			Iterator var2 = this.mProviders.entrySet().iterator();

			while (var2.hasNext()) {
				Map.Entry<Class<? extends XplatProvider>, XplatProvider> entry = (Map.Entry) var2.next();
				sb.append(entry.getValue()).append("\n");
			}
		}

		sb.append("(DefaultProviderManager)").append("\n");
		return sb.toString();
	}
}