package com.xforceplus.tower.common.track.properties.provider.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xforceplus.tower.common.track.io.UnicodeInputStream;
import com.xforceplus.tower.common.track.properties.provider.XplatAppIdProvider;
import com.xforceplus.tower.common.track.properties.provider.XplatProvider;
import com.xforceplus.tower.common.utils.Utils;
/**
 * 链路追踪
 * @ClassName: DefaultXplatAppIdProvider. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:54:35 
 *
 */
public class DefaultXplatAppIdProvider implements XplatAppIdProvider {
	private static final Logger logger = LoggerFactory.getLogger(DefaultXplatAppIdProvider.class);
	public static final String APP_PROPERTIES_CLASSPATH = "/META-INF/app.properties";
	public static final String PROPERTIES_KEY = "app.id";
	private Properties mAppProperties = new Properties();
	private String mAppId;

	public DefaultXplatAppIdProvider() {
	}

	@Override
	public void initialize() {
		try {
			InputStream in = Thread.currentThread().getContextClassLoader()
					.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
			if (in == null) {
				in = DefaultXplatAppIdProvider.class.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
			}
			if (in == null) {
				logger.warn("{} not found from classpath!", APP_PROPERTIES_CLASSPATH);
			}
			this.initialize(in);
		} catch (Throwable var2) {
			logger.error("Initialize DefaultApplicationProvider failed.", var2);
		}

	}

	@Override
	public void initialize(InputStream in) {
		try {
			if (in != null) {
				try {
					this.mAppProperties
							.load(new InputStreamReader(new UnicodeInputStream(in, "utf-8"), StandardCharsets.UTF_8));
				} finally {
					in.close();
				}
			}

			this.initAppId();
		} catch (Throwable var6) {
			logger.error("Initialize DefaultApplicationProvider failed.", var6);
		}

	}

	@Override
	public String getAppId() {
		return this.mAppId;
	}

	@Override
	public boolean isAppIdSet() {
		return !Utils.isBlank(this.mAppId);
	}

	@Override
	public String getProperty(String name, String defaultValue) {
		String val;
		if (PROPERTIES_KEY.equals(name)) {
			val = this.getAppId();
			return val == null ? defaultValue : val;
		} else {
			val = this.mAppProperties.getProperty(name, defaultValue);
			return val == null ? defaultValue : val;
		}
	}

	@Override
	public Class<? extends XplatProvider> getType() {
		return XplatAppIdProvider.class;
	}

	private void initAppId() {
		this.mAppId = System.getProperty(PROPERTIES_KEY);
		if (!Utils.isBlank(this.mAppId)) {
			this.mAppId = this.mAppId.trim();
			logger.info("{}is set to {} by {} property from System Property", PROPERTIES_KEY, this.mAppId,
					PROPERTIES_KEY);
		} else {
			this.mAppId = this.mAppProperties.getProperty(PROPERTIES_KEY);
			if (!Utils.isBlank(this.mAppId)) {
				this.mAppId = this.mAppId.trim();
				logger.info("{} is set to {} by {} property from {}", PROPERTIES_KEY, this.mAppId, PROPERTIES_KEY,
						APP_PROPERTIES_CLASSPATH);
			} else {
				this.mAppId = null;
				logger.warn("{} is not available from System Property and {}. It is set to null", PROPERTIES_KEY,
						APP_PROPERTIES_CLASSPATH);
			}
		}
	}

	@Override
	public String toString() {
		return "appId [" + this.getAppId() + "] properties: " + this.mAppProperties + " (DefaultApplicationProvider)";
	}
}
