package com.xforceplus.tower.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xforceplus.tower.common.track.properties.provider.factory.AbstractFactoryXplatProvider;
/**
 * 工具类
 * @ClassName: ConfigUtil. 
 * @Description: TODO
 * @author zhaochao
 * @date 2019年11月4日 下午8:55:17 
 *
 */
public class ConfigUtil {
	private static final Logger logger = LoggerFactory.getLogger(ConfigUtil.class);

	public ConfigUtil() {

	}

	public static String getAppId() {
		String appId = AbstractFactoryXplatProvider.app().getAppId();
		if (Utils.isBlank(appId)) {
			appId = "XplatNoAppIdPlaceHolder";
			logger.warn("app.id is not set, please make sure it is set in classpath:/META-INF/app.properties!");
		}
		return appId;
	}

	public static String getAppVersion() {
		String appVersion = AbstractFactoryXplatProvider.version().getAppVersion();
		if (Utils.isBlank(appVersion)) {
			appVersion = "XplatNoAppIdPlaceHolder";
			logger.warn("app.id is not set, please make sure it is set in classpath:/META-INF/app.properties!");
		}
		return appVersion;
	}
}