/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import com.xforceplus.tower.storage.cache.CaffeineCacheEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableCaching
@EnableScheduling
public class CacheManagerConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public CacheManager firstCaffeineCacheManager() {
        this.logger.info("=======================building cacheManager==================================");
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        ArrayList caches = Lists.newArrayList();
        for (CaffeineCacheEnum caffeineCacheEnum : CaffeineCacheEnum.values()) {
            caches.add(new CaffeineCache(caffeineCacheEnum.getCacheName(), Caffeine.newBuilder().initialCapacity(100).expireAfterWrite((long)caffeineCacheEnum.getTtl(), TimeUnit.SECONDS).maximumSize((long)caffeineCacheEnum.getMaxSize()).build()));
        }
        cacheManager.setCaches((Collection)caches);
        return cacheManager;
    }
}

