/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.service;

import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.StorageClass;
import com.xforceplus.tower.file.client.apiclient.FileWaterMarkApiClient;
import com.xforceplus.tower.file.client.model.SignatureResult;
import com.xforceplus.tower.file.client.model.StorageOrig;
import com.xforceplus.tower.file.client.model.WaterMarkStyle;
import com.xforceplus.tower.storage.cache.FileStorageCacheManger;
import com.xforceplus.tower.storage.constant.ExpireTime;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.FileWrapper;
import com.xforceplus.tower.storage.utils.CommonTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class AliyunOssWrapper
implements FileWrapper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileStorageCacheManger fileStorageCacheManger;
    @Autowired
    private FileWaterMarkApiClient fileWaterMarkApiClient;

    @Override
    public void uploadFileBySignature(MultipartFile file, Long tenantId, String filePath, String storageOrig) {
        String objectAcl = CannedAccessControlList.PublicReadWrite.toString();
        if (StorageOrig.OSS_PRIVATE.value().equals(storageOrig)) {
            objectAcl = CannedAccessControlList.Private.toString();
        }
        CloseableHttpClient httpClient = null;
        try {
            SignatureResult signatureResult = this.fileStorageCacheManger.getSignatureResult(tenantId, filePath, storageOrig);
            httpClient = HttpClientBuilder.create().build();
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Consts.UTF_8);
            String fileName = new String(file.getOriginalFilename().getBytes(), "UTF-8");
            multipartEntityBuilder.addPart("x-oss-storage-class", (ContentBody)new StringBody(StorageClass.Standard.name(), contentType));
            multipartEntityBuilder.addPart("x-oss-object-acl", (ContentBody)new StringBody(objectAcl, contentType));
            multipartEntityBuilder.addPart("key", (ContentBody)new StringBody(signatureResult.getFilePath(), contentType));
            multipartEntityBuilder.addPart("policy", (ContentBody)new StringBody(signatureResult.getEncodePolicy(), contentType));
            multipartEntityBuilder.addPart("OSSAccessKeyId", (ContentBody)new StringBody(signatureResult.getoSSAccessKeyId(), contentType));
            multipartEntityBuilder.addPart("success_action_status", (ContentBody)new StringBody("200", contentType));
            multipartEntityBuilder.addPart("signature", (ContentBody)new StringBody(signatureResult.getSignature(), contentType));
            multipartEntityBuilder.addBinaryBody("file", file.getInputStream(), ContentType.DEFAULT_BINARY, fileName);
            HttpPost httpPost = new HttpPost(signatureResult.getUrlStr());
            httpPost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            this.logger.info("httpResponse :{}", (Object)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("upload file fail");
            }
        }
        catch (IOException e) {
            this.logger.error("uploadFileBySignature file error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    this.logger.error("httpclient close error ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public InputStream inputStreamBySignatureUrl(Long tenantId, Long id, String storageType) {
        String urlStr = this.fileStorageCacheManger.getSignatureUrl(tenantId, id, storageType, ExpireTime.OSS_EXPIRE.time());
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            return conn.getInputStream();
        }
        catch (IOException e) {
            this.logger.error("inputStreamBySignatureUrl file error:{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getThumbnailUrl(String url, int height, int width) {
        return url + "?x-oss-process=image/resize,m_fill,h_" + height + ",w_" + width + ",limit_0";
    }

    @Override
    public void generateWaterMark(UploadFileRequest uploadFileRequest, Long fileId, StorageOrig storageOrig) {
        Long tenantId = uploadFileRequest.getTenantId();
        if (uploadFileRequest.getWaterMarkRequest() == null) {
            return;
        }
        String style = CommonTools.getWaterMarkStyle(uploadFileRequest.getWaterMarkRequest());
        if (CommonTools.isEmpty(style)) {
            return;
        }
        WaterMarkStyle waterMarkStyle = new WaterMarkStyle();
        waterMarkStyle.setStyle(style);
        waterMarkStyle.setStorageOrig(storageOrig.value());
        this.fileWaterMarkApiClient.generateWatermark(tenantId, fileId, waterMarkStyle);
    }
}

