/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.service;

import com.xforceplus.tower.file.client.apiclient.FileStorageApiClient;
import com.xforceplus.tower.file.client.model.ResponseCodes;
import com.xforceplus.tower.file.client.model.StorageOrig;
import com.xforceplus.tower.storage.constant.ExpireTime;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.FileWrapper;
import com.xforceplus.tower.storage.utils.FileUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioWrapper
implements FileWrapper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer time_out = 20;
    private static final Long expire_time = ExpireTime.MINIO_EXPIRE.time();
    @Autowired
    private FileUtils fileUtils;
    @Autowired
    private FileStorageApiClient fileStorageApiClient;

    @Override
    public void uploadFileBySignature(MultipartFile file, Long tenantId, String filePath, String storageOrig) throws Exception {
        try {
            com.xforceplus.tower.file.client.model.Response writeSignature = this.fileStorageApiClient.getWriteSignature(tenantId, filePath, expire_time, StorageOrig.getStorageOrig((String)storageOrig));
            if (!ResponseCodes.SUCCESS.value().equals(writeSignature.getCode())) {
                throw new Exception(writeSignature.getMessage());
            }
            String urlString = (String)writeSignature.getResult();
            byte[] data = this.fileUtils.toByteArray(file.getInputStream());
            Request.Builder requestBuilder = new Request.Builder();
            Request request = requestBuilder.url(HttpUrl.parse((String)urlString)).method("PUT", RequestBody.create(null, (byte[])data)).addHeader("x-amz-acl", "bucket-owner-full-control").build();
            OkHttpClient transport = new OkHttpClient().newBuilder().connectTimeout((long)time_out.intValue(), TimeUnit.SECONDS).writeTimeout((long)time_out.intValue(), TimeUnit.SECONDS).readTimeout((long)time_out.intValue(), TimeUnit.SECONDS).build();
            Response response = transport.newCall(request).execute();
            if (response == null) {
                throw new Exception("empty response");
            }
            response.body().close();
        }
        catch (Exception e) {
            this.logger.error("minio upload error: ", (Throwable)e);
        }
    }

    @Override
    public InputStream inputStreamBySignatureUrl(Long tenantId, Long fileId, String storageOrig) {
        com.xforceplus.tower.file.client.model.Response readSignature = this.fileStorageApiClient.getReadSignature(tenantId, fileId, expire_time, StorageOrig.getStorageOrig((String)storageOrig));
        if (!ResponseCodes.SUCCESS.value().equals(readSignature.getCode())) {
            throw new RuntimeException(readSignature.getMessage());
        }
        String urlStr = (String)readSignature.getResult();
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            return conn.getInputStream();
        }
        catch (Exception e) {
            this.logger.error("get inputStream error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getThumbnailUrl(String url, int height, int width) {
        return "";
    }

    @Override
    public void generateWaterMark(UploadFileRequest uploadFileRequest, Long fileId, StorageOrig storageOrig) {
    }
}

