/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class zipFileUtil {
    public static void downLoadInputStream(InputStream inputStream, String fileName, String savePath) throws IOException {
        byte[] getData = zipFileUtil.readInputStream(inputStream);
        File saveDir = new File(savePath);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        File file = new File(saveDir + File.separator + fileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(getData);
        fos.close();
        inputStream.close();
        System.out.println("info:" + fileName + " download success");
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static void zipFiles(List<File> srcFiles, String zipFilePath) throws Exception {
        System.out.println("\u538b\u7f29\u4e2d...");
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            zipFile.getParentFile().mkdirs();
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFilePath));
        BufferedOutputStream bo = new BufferedOutputStream(out);
        for (File srcFile : srcFiles) {
            zipFileUtil.zip(out, srcFile, srcFile.getName(), bo);
        }
        bo.close();
        out.close();
        System.out.println("\u538b\u7f29\u5b8c\u6210");
    }

    private static void zip(ZipOutputStream out, File srcFile, String base, BufferedOutputStream bo) throws Exception {
        if (srcFile.isDirectory()) {
            File[] fileList = srcFile.listFiles();
            if (fileList.length == 0) {
                out.putNextEntry(new ZipEntry(base + "/"));
                out.closeEntry();
            }
            for (int i = 0; i < fileList.length; ++i) {
                zipFileUtil.zip(out, fileList[i], base + "/" + fileList[i].getName(), bo);
            }
        } else {
            out.putNextEntry(new ZipEntry(base));
            FileInputStream in = new FileInputStream(srcFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            in.close();
        }
    }
}

