package com.xforceplus.ultstateflow.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * action业务类别
 * </p>
 *
 * @author ultraman
 * @since 2021-02-03
 */
public enum ActionBusinessType {

    _1("1", "Condition"),
    _2("2", "Validator"),
    _3("3", "TransitionAction"),
    _4("4", "StateEntryAction"),
    _5("5", "StateExitAction");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ActionBusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ActionBusinessType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
