package com.xforceplus.ultstateflow.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * action类别
 * </p>
 *
 * @author ultraman
 * @since 2021-02-03
 */
public enum ActionType {

    _1("1", "本地调用"),
    _2("2", "API"),
    _3("3", "规则函数");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ActionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ActionType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
