package com.xforceplus.ultstateflow.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-02-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Action implements Serializable {

  private static final long serialVersionUID=1L;

  private String actionName;

  private Long actionType;

  private Long actionBusinessType;

  private String actionCode;

  private String actionContent;

  private String actionDesc;

  private String objectCode;

  private Long version;

  private Long publishOriginActionId;

  private Long appId;

  private String tenantName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String inputKey;

  private String outpuKey;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("action_name", actionName);
      map.put("action_type", actionType);
      map.put("action_business_type", actionBusinessType);
      map.put("action_code", actionCode);
      map.put("action_content", actionContent);
      map.put("action_desc", actionDesc);
      map.put("object_code", objectCode);
      map.put("version", version);
      map.put("publish_origin_action_id", publishOriginActionId);
      map.put("app_id", appId);
      map.put("tenant_name", tenantName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("input_key", inputKey);
      map.put("outpu_key", outpuKey);
      return map;
  }

  public static Action fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    Action entity = new Action();
    if(map.containsKey("action_name")) {
      Object obj = map.get("action_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("action_type")) {
      Object obj = map.get("action_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActionType((Long)obj);
        } else if(obj instanceof String) {
          entity.setActionType(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("action_business_type")) {
      Object obj = map.get("action_business_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActionBusinessType((Long)obj);
        } else if(obj instanceof String) {
          entity.setActionBusinessType(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("action_code")) {
      Object obj = map.get("action_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("action_content")) {
      Object obj = map.get("action_content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActionContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("action_desc")) {
      Object obj = map.get("action_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActionDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("object_code")) {
      Object obj = map.get("object_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setObjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String) {
          entity.setVersion(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("publish_origin_action_id")) {
      Object obj = map.get("publish_origin_action_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPublishOriginActionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPublishOriginActionId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAppId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("input_key")) {
      Object obj = map.get("input_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInputKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outpu_key")) {
      Object obj = map.get("outpu_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutpuKey((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
