package com.xforceplus.ultstateflow.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-02-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AutomationRule implements Serializable {

  private static final long serialVersionUID=1L;

  private String ruleName;

  private String objectCode;

  private Long triggerSourceId;

  private Long automationTriggerTypeId;

  private String condition;

  private String actionDefinition;

  private Long transactionType;

  private String extendAttribute;

  private Long appId;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rule_name", ruleName);
      map.put("object_code", objectCode);
      map.put("trigger_source_id", triggerSourceId);
      map.put("automation_trigger_type_id", automationTriggerTypeId);
      map.put("condition", condition);
      map.put("action_definition", actionDefinition);
      map.put("transaction_type", transactionType);
      map.put("extend_attribute", extendAttribute);
      map.put("app_id", appId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static AutomationRule fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    AutomationRule entity = new AutomationRule();
    if(map.containsKey("rule_name")) {
      Object obj = map.get("rule_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRuleName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("object_code")) {
      Object obj = map.get("object_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setObjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trigger_source_id")) {
      Object obj = map.get("trigger_source_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTriggerSourceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTriggerSourceId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("automation_trigger_type_id")) {
      Object obj = map.get("automation_trigger_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAutomationTriggerTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAutomationTriggerTypeId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("condition")) {
      Object obj = map.get("condition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCondition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("action_definition")) {
      Object obj = map.get("action_definition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActionDefinition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transaction_type")) {
      Object obj = map.get("transaction_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransactionType((Long)obj);
        } else if(obj instanceof String) {
          entity.setTransactionType(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("extend_attribute")) {
      Object obj = map.get("extend_attribute");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtendAttribute((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAppId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
