package com.xforceplus.ultstateflow.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-02-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ObjectState implements Serializable {

  private static final long serialVersionUID=1L;

  private String objectName;

  private String objectCode;

  private String stateField;

  private String stateFieldName;

  private String stateFieldValue;

  private Long appId;

  private Long refId;

  private Long publishStateId;

  private String publishFlag;

  private Long version;

  private String enableFlag;

  private Long fieldId;

  private Long enumId;

  private String tenantName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("object_name", objectName);
      map.put("object_code", objectCode);
      map.put("state_field", stateField);
      map.put("state_field_name", stateFieldName);
      map.put("state_field_value", stateFieldValue);
      map.put("app_id", appId);
      map.put("ref_id", refId);
      map.put("publish_state_id", publishStateId);
      map.put("publish_flag", publishFlag);
      map.put("version", version);
      map.put("enable_flag", enableFlag);
      map.put("field_id", fieldId);
      map.put("enum_id", enumId);
      map.put("tenant_name", tenantName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ObjectState fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ObjectState entity = new ObjectState();
    if(map.containsKey("object_name")) {
      Object obj = map.get("object_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setObjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("object_code")) {
      Object obj = map.get("object_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setObjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state_field")) {
      Object obj = map.get("state_field");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStateField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state_field_name")) {
      Object obj = map.get("state_field_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStateFieldName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state_field_value")) {
      Object obj = map.get("state_field_value");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStateFieldValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAppId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ref_id")) {
      Object obj = map.get("ref_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefId((Long)obj);
        } else if(obj instanceof String) {
          entity.setRefId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("publish_state_id")) {
      Object obj = map.get("publish_state_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPublishStateId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPublishStateId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("publish_flag")) {
      Object obj = map.get("publish_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPublishFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String) {
          entity.setVersion(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enable_flag")) {
      Object obj = map.get("enable_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnableFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("field_id")) {
      Object obj = map.get("field_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFieldId((Long)obj);
        } else if(obj instanceof String) {
          entity.setFieldId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enum_id")) {
      Object obj = map.get("enum_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEnumId((Long)obj);
        } else if(obj instanceof String) {
          entity.setEnumId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
