package com.xforceplus.ultstateflow.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-02-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StateMachineDefinitionItem implements Serializable {

  private static final long serialVersionUID=1L;

  private Long machineDefinitionId;

  private String transitionName;

  private Long transitionType;

  private Long sourceStateValueId;

  private Long targetStateValueId;

  private String transitionCondition;

  private String transitionValidation;

  private String transitionAction;

  private String extendAttribute;

  private String tenantName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String code;

  private Long transactionType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("machine_definition_id", machineDefinitionId);
      map.put("transition_name", transitionName);
      map.put("transition_type", transitionType);
      map.put("source_state_value_id", sourceStateValueId);
      map.put("target_state_value_id", targetStateValueId);
      map.put("transition_condition", transitionCondition);
      map.put("transition_validation", transitionValidation);
      map.put("transition_action", transitionAction);
      map.put("extend_attribute", extendAttribute);
      map.put("tenant_name", tenantName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("code", code);
      map.put("transaction_type", transactionType);
      return map;
  }

  public static StateMachineDefinitionItem fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    StateMachineDefinitionItem entity = new StateMachineDefinitionItem();
    if(map.containsKey("machine_definition_id")) {
      Object obj = map.get("machine_definition_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMachineDefinitionId((Long)obj);
        } else if(obj instanceof String) {
          entity.setMachineDefinitionId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("transition_name")) {
      Object obj = map.get("transition_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTransitionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transition_type")) {
      Object obj = map.get("transition_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransitionType((Long)obj);
        } else if(obj instanceof String) {
          entity.setTransitionType(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("source_state_value_id")) {
      Object obj = map.get("source_state_value_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSourceStateValueId((Long)obj);
        } else if(obj instanceof String) {
          entity.setSourceStateValueId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("target_state_value_id")) {
      Object obj = map.get("target_state_value_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTargetStateValueId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTargetStateValueId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("transition_condition")) {
      Object obj = map.get("transition_condition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTransitionCondition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transition_validation")) {
      Object obj = map.get("transition_validation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTransitionValidation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transition_action")) {
      Object obj = map.get("transition_action");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTransitionAction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extend_attribute")) {
      Object obj = map.get("extend_attribute");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtendAttribute((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transaction_type")) {
      Object obj = map.get("transaction_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransactionType((Long)obj);
        } else if(obj instanceof String) {
          entity.setTransactionType(Long.parseLong((String)obj));
        }
      } else{
      }
    }
    return entity;
  }
}
