package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.Action;
import com.xforceplus.ultstateflow.service.IActionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class ActionController {

  @Autowired
  private IActionService actionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param action ${table.comment}
   * @return
   */
  @GetMapping("/actions" )
  public XfR getActions(XfPage page, Action action) {
    return XfR.ok(actionServiceImpl.page(page, Wrappers.query(action)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/actions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(actionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param action ${table.comment}
   * @return XfR
   */
  @PostMapping("/actions")
  public XfR save(@RequestBody Action action) {
     return XfR.ok(actionServiceImpl.save(action));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param action ${table.comment}
   * @return XfR
   */
  @PutMapping("/actions/{id}")
  public XfR putUpdate(@RequestBody Action action,@PathVariable Long id) {
      action.setId(id);
      return XfR.ok(actionServiceImpl.updateById(action));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param action ${table.comment}
   * @return XfR
   */
  @PatchMapping("/actions/{id}")
  public XfR patchUpdate(@RequestBody Action action,@PathVariable Long id) {
      Action upaction = actionServiceImpl.getById(id);
      if(upaction != null){
        upaction = ObjectCopyUtils.copyProperties(action,upaction,true);
      }
      return XfR.ok(actionServiceImpl.updateById(upaction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/actions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(actionServiceImpl.removeById(id));
  }

  @PostMapping("/actions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "action");
     params.put("request", condition);

     return XfR.ok(actionServiceImpl.querys(params));
  }

}
