package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.AutomationRuleAction;
import com.xforceplus.ultstateflow.service.IAutomationRuleActionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class AutomationRuleActionController {

  @Autowired
  private IAutomationRuleActionService automationRuleActionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param automationRuleAction ${table.comment}
   * @return
   */
  @GetMapping("/automationruleactions" )
  public XfR getAutomationRuleActions(XfPage page, AutomationRuleAction automationRuleAction) {
    return XfR.ok(automationRuleActionServiceImpl.page(page, Wrappers.query(automationRuleAction)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/automationruleactions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(automationRuleActionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param automationRuleAction ${table.comment}
   * @return XfR
   */
  @PostMapping("/automationruleactions")
  public XfR save(@RequestBody AutomationRuleAction automationRuleAction) {
     return XfR.ok(automationRuleActionServiceImpl.save(automationRuleAction));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param automationRuleAction ${table.comment}
   * @return XfR
   */
  @PutMapping("/automationruleactions/{id}")
  public XfR putUpdate(@RequestBody AutomationRuleAction automationRuleAction,@PathVariable Long id) {
      automationRuleAction.setId(id);
      return XfR.ok(automationRuleActionServiceImpl.updateById(automationRuleAction));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param automationRuleAction ${table.comment}
   * @return XfR
   */
  @PatchMapping("/automationruleactions/{id}")
  public XfR patchUpdate(@RequestBody AutomationRuleAction automationRuleAction,@PathVariable Long id) {
      AutomationRuleAction upautomationRuleAction = automationRuleActionServiceImpl.getById(id);
      if(upautomationRuleAction != null){
        upautomationRuleAction = ObjectCopyUtils.copyProperties(automationRuleAction,upautomationRuleAction,true);
      }
      return XfR.ok(automationRuleActionServiceImpl.updateById(upautomationRuleAction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/automationruleactions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(automationRuleActionServiceImpl.removeById(id));
  }

  @PostMapping("/automationruleactions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "automation_rule_action");
     params.put("request", condition);

     return XfR.ok(automationRuleActionServiceImpl.querys(params));
  }

}
