package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.AutomationRule;
import com.xforceplus.ultstateflow.service.IAutomationRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class AutomationRuleController {

  @Autowired
  private IAutomationRuleService automationRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param automationRule ${table.comment}
   * @return
   */
  @GetMapping("/automationrules" )
  public XfR getAutomationRules(XfPage page, AutomationRule automationRule) {
    return XfR.ok(automationRuleServiceImpl.page(page, Wrappers.query(automationRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/automationrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(automationRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param automationRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/automationrules")
  public XfR save(@RequestBody AutomationRule automationRule) {
     return XfR.ok(automationRuleServiceImpl.save(automationRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param automationRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/automationrules/{id}")
  public XfR putUpdate(@RequestBody AutomationRule automationRule,@PathVariable Long id) {
      automationRule.setId(id);
      return XfR.ok(automationRuleServiceImpl.updateById(automationRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param automationRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/automationrules/{id}")
  public XfR patchUpdate(@RequestBody AutomationRule automationRule,@PathVariable Long id) {
      AutomationRule upautomationRule = automationRuleServiceImpl.getById(id);
      if(upautomationRule != null){
        upautomationRule = ObjectCopyUtils.copyProperties(automationRule,upautomationRule,true);
      }
      return XfR.ok(automationRuleServiceImpl.updateById(upautomationRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/automationrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(automationRuleServiceImpl.removeById(id));
  }

  @PostMapping("/automationrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "automation_rule");
     params.put("request", condition);

     return XfR.ok(automationRuleServiceImpl.querys(params));
  }

}
