package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.AutomationTriggerType;
import com.xforceplus.ultstateflow.service.IAutomationTriggerTypeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class AutomationTriggerTypeController {

  @Autowired
  private IAutomationTriggerTypeService automationTriggerTypeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param automationTriggerType ${table.comment}
   * @return
   */
  @GetMapping("/automationtriggertypes" )
  public XfR getAutomationTriggerTypes(XfPage page, AutomationTriggerType automationTriggerType) {
    return XfR.ok(automationTriggerTypeServiceImpl.page(page, Wrappers.query(automationTriggerType)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/automationtriggertypes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(automationTriggerTypeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param automationTriggerType ${table.comment}
   * @return XfR
   */
  @PostMapping("/automationtriggertypes")
  public XfR save(@RequestBody AutomationTriggerType automationTriggerType) {
     return XfR.ok(automationTriggerTypeServiceImpl.save(automationTriggerType));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param automationTriggerType ${table.comment}
   * @return XfR
   */
  @PutMapping("/automationtriggertypes/{id}")
  public XfR putUpdate(@RequestBody AutomationTriggerType automationTriggerType,@PathVariable Long id) {
      automationTriggerType.setId(id);
      return XfR.ok(automationTriggerTypeServiceImpl.updateById(automationTriggerType));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param automationTriggerType ${table.comment}
   * @return XfR
   */
  @PatchMapping("/automationtriggertypes/{id}")
  public XfR patchUpdate(@RequestBody AutomationTriggerType automationTriggerType,@PathVariable Long id) {
      AutomationTriggerType upautomationTriggerType = automationTriggerTypeServiceImpl.getById(id);
      if(upautomationTriggerType != null){
        upautomationTriggerType = ObjectCopyUtils.copyProperties(automationTriggerType,upautomationTriggerType,true);
      }
      return XfR.ok(automationTriggerTypeServiceImpl.updateById(upautomationTriggerType));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/automationtriggertypes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(automationTriggerTypeServiceImpl.removeById(id));
  }

  @PostMapping("/automationtriggertypes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "automation_trigger_type");
     params.put("request", condition);

     return XfR.ok(automationTriggerTypeServiceImpl.querys(params));
  }

}
