package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.ObjectState;
import com.xforceplus.ultstateflow.service.IObjectStateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class ObjectStateController {

  @Autowired
  private IObjectStateService objectStateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param objectState ${table.comment}
   * @return
   */
  @GetMapping("/objectstates" )
  public XfR getObjectStates(XfPage page, ObjectState objectState) {
    return XfR.ok(objectStateServiceImpl.page(page, Wrappers.query(objectState)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/objectstates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(objectStateServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param objectState ${table.comment}
   * @return XfR
   */
  @PostMapping("/objectstates")
  public XfR save(@RequestBody ObjectState objectState) {
     return XfR.ok(objectStateServiceImpl.save(objectState));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param objectState ${table.comment}
   * @return XfR
   */
  @PutMapping("/objectstates/{id}")
  public XfR putUpdate(@RequestBody ObjectState objectState,@PathVariable Long id) {
      objectState.setId(id);
      return XfR.ok(objectStateServiceImpl.updateById(objectState));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param objectState ${table.comment}
   * @return XfR
   */
  @PatchMapping("/objectstates/{id}")
  public XfR patchUpdate(@RequestBody ObjectState objectState,@PathVariable Long id) {
      ObjectState upobjectState = objectStateServiceImpl.getById(id);
      if(upobjectState != null){
        upobjectState = ObjectCopyUtils.copyProperties(objectState,upobjectState,true);
      }
      return XfR.ok(objectStateServiceImpl.updateById(upobjectState));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/objectstates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(objectStateServiceImpl.removeById(id));
  }

  @PostMapping("/objectstates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "object_state");
     params.put("request", condition);

     return XfR.ok(objectStateServiceImpl.querys(params));
  }

}
