package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.ObjectStateValue;
import com.xforceplus.ultstateflow.service.IObjectStateValueService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class ObjectStateValueController {

  @Autowired
  private IObjectStateValueService objectStateValueServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param objectStateValue ${table.comment}
   * @return
   */
  @GetMapping("/objectstatevalues" )
  public XfR getObjectStateValues(XfPage page, ObjectStateValue objectStateValue) {
    return XfR.ok(objectStateValueServiceImpl.page(page, Wrappers.query(objectStateValue)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/objectstatevalues/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(objectStateValueServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param objectStateValue ${table.comment}
   * @return XfR
   */
  @PostMapping("/objectstatevalues")
  public XfR save(@RequestBody ObjectStateValue objectStateValue) {
     return XfR.ok(objectStateValueServiceImpl.save(objectStateValue));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param objectStateValue ${table.comment}
   * @return XfR
   */
  @PutMapping("/objectstatevalues/{id}")
  public XfR putUpdate(@RequestBody ObjectStateValue objectStateValue,@PathVariable Long id) {
      objectStateValue.setId(id);
      return XfR.ok(objectStateValueServiceImpl.updateById(objectStateValue));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param objectStateValue ${table.comment}
   * @return XfR
   */
  @PatchMapping("/objectstatevalues/{id}")
  public XfR patchUpdate(@RequestBody ObjectStateValue objectStateValue,@PathVariable Long id) {
      ObjectStateValue upobjectStateValue = objectStateValueServiceImpl.getById(id);
      if(upobjectStateValue != null){
        upobjectStateValue = ObjectCopyUtils.copyProperties(objectStateValue,upobjectStateValue,true);
      }
      return XfR.ok(objectStateValueServiceImpl.updateById(upobjectStateValue));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/objectstatevalues/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(objectStateValueServiceImpl.removeById(id));
  }

  @PostMapping("/objectstatevalues/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "object_state_value");
     params.put("request", condition);

     return XfR.ok(objectStateValueServiceImpl.querys(params));
  }

}
