package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.StateMachineDefinition;
import com.xforceplus.ultstateflow.service.IStateMachineDefinitionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class StateMachineDefinitionController {

  @Autowired
  private IStateMachineDefinitionService stateMachineDefinitionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param stateMachineDefinition ${table.comment}
   * @return
   */
  @GetMapping("/statemachinedefinitions" )
  public XfR getStateMachineDefinitions(XfPage page, StateMachineDefinition stateMachineDefinition) {
    return XfR.ok(stateMachineDefinitionServiceImpl.page(page, Wrappers.query(stateMachineDefinition)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statemachinedefinitions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(stateMachineDefinitionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param stateMachineDefinition ${table.comment}
   * @return XfR
   */
  @PostMapping("/statemachinedefinitions")
  public XfR save(@RequestBody StateMachineDefinition stateMachineDefinition) {
     return XfR.ok(stateMachineDefinitionServiceImpl.save(stateMachineDefinition));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param stateMachineDefinition ${table.comment}
   * @return XfR
   */
  @PutMapping("/statemachinedefinitions/{id}")
  public XfR putUpdate(@RequestBody StateMachineDefinition stateMachineDefinition,@PathVariable Long id) {
      stateMachineDefinition.setId(id);
      return XfR.ok(stateMachineDefinitionServiceImpl.updateById(stateMachineDefinition));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param stateMachineDefinition ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statemachinedefinitions/{id}")
  public XfR patchUpdate(@RequestBody StateMachineDefinition stateMachineDefinition,@PathVariable Long id) {
      StateMachineDefinition upstateMachineDefinition = stateMachineDefinitionServiceImpl.getById(id);
      if(upstateMachineDefinition != null){
        upstateMachineDefinition = ObjectCopyUtils.copyProperties(stateMachineDefinition,upstateMachineDefinition,true);
      }
      return XfR.ok(stateMachineDefinitionServiceImpl.updateById(upstateMachineDefinition));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statemachinedefinitions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(stateMachineDefinitionServiceImpl.removeById(id));
  }

  @PostMapping("/statemachinedefinitions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "state_machine_definition");
     params.put("request", condition);

     return XfR.ok(stateMachineDefinitionServiceImpl.querys(params));
  }

}
