package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.StateMachineDefinitionItem;
import com.xforceplus.ultstateflow.service.IStateMachineDefinitionItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class StateMachineDefinitionItemController {

  @Autowired
  private IStateMachineDefinitionItemService stateMachineDefinitionItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param stateMachineDefinitionItem ${table.comment}
   * @return
   */
  @GetMapping("/statemachinedefinitionitems" )
  public XfR getStateMachineDefinitionItems(XfPage page, StateMachineDefinitionItem stateMachineDefinitionItem) {
    return XfR.ok(stateMachineDefinitionItemServiceImpl.page(page, Wrappers.query(stateMachineDefinitionItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statemachinedefinitionitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(stateMachineDefinitionItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param stateMachineDefinitionItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/statemachinedefinitionitems")
  public XfR save(@RequestBody StateMachineDefinitionItem stateMachineDefinitionItem) {
     return XfR.ok(stateMachineDefinitionItemServiceImpl.save(stateMachineDefinitionItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param stateMachineDefinitionItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/statemachinedefinitionitems/{id}")
  public XfR putUpdate(@RequestBody StateMachineDefinitionItem stateMachineDefinitionItem,@PathVariable Long id) {
      stateMachineDefinitionItem.setId(id);
      return XfR.ok(stateMachineDefinitionItemServiceImpl.updateById(stateMachineDefinitionItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param stateMachineDefinitionItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statemachinedefinitionitems/{id}")
  public XfR patchUpdate(@RequestBody StateMachineDefinitionItem stateMachineDefinitionItem,@PathVariable Long id) {
      StateMachineDefinitionItem upstateMachineDefinitionItem = stateMachineDefinitionItemServiceImpl.getById(id);
      if(upstateMachineDefinitionItem != null){
        upstateMachineDefinitionItem = ObjectCopyUtils.copyProperties(stateMachineDefinitionItem,upstateMachineDefinitionItem,true);
      }
      return XfR.ok(stateMachineDefinitionItemServiceImpl.updateById(upstateMachineDefinitionItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statemachinedefinitionitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(stateMachineDefinitionItemServiceImpl.removeById(id));
  }

  @PostMapping("/statemachinedefinitionitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "state_machine_definition_item");
     params.put("request", condition);

     return XfR.ok(stateMachineDefinitionItemServiceImpl.querys(params));
  }

}
