package com.xforceplus.ultstateflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultstateflow.entity.StateMachineTransitionAction;
import com.xforceplus.ultstateflow.service.IStateMachineTransitionActionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-13
 */
@RestController
public class StateMachineTransitionActionController {

  @Autowired
  private IStateMachineTransitionActionService stateMachineTransitionActionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param stateMachineTransitionAction ${table.comment}
   * @return
   */
  @GetMapping("/statemachinetransitionactions" )
  public XfR getStateMachineTransitionActions(XfPage page, StateMachineTransitionAction stateMachineTransitionAction) {
    return XfR.ok(stateMachineTransitionActionServiceImpl.page(page, Wrappers.query(stateMachineTransitionAction)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statemachinetransitionactions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(stateMachineTransitionActionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param stateMachineTransitionAction ${table.comment}
   * @return XfR
   */
  @PostMapping("/statemachinetransitionactions")
  public XfR save(@RequestBody StateMachineTransitionAction stateMachineTransitionAction) {
     return XfR.ok(stateMachineTransitionActionServiceImpl.save(stateMachineTransitionAction));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param stateMachineTransitionAction ${table.comment}
   * @return XfR
   */
  @PutMapping("/statemachinetransitionactions/{id}")
  public XfR putUpdate(@RequestBody StateMachineTransitionAction stateMachineTransitionAction,@PathVariable Long id) {
      stateMachineTransitionAction.setId(id);
      return XfR.ok(stateMachineTransitionActionServiceImpl.updateById(stateMachineTransitionAction));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param stateMachineTransitionAction ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statemachinetransitionactions/{id}")
  public XfR patchUpdate(@RequestBody StateMachineTransitionAction stateMachineTransitionAction,@PathVariable Long id) {
      StateMachineTransitionAction upstateMachineTransitionAction = stateMachineTransitionActionServiceImpl.getById(id);
      if(upstateMachineTransitionAction != null){
        upstateMachineTransitionAction = ObjectCopyUtils.copyProperties(stateMachineTransitionAction,upstateMachineTransitionAction,true);
      }
      return XfR.ok(stateMachineTransitionActionServiceImpl.updateById(upstateMachineTransitionAction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statemachinetransitionactions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(stateMachineTransitionActionServiceImpl.removeById(id));
  }

  @PostMapping("/statemachinetransitionactions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "state_machine_transition_action");
     params.put("request", condition);

     return XfR.ok(stateMachineTransitionActionServiceImpl.querys(params));
  }

}
