package com.xforceplus.ultstatemachine.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 启用标记
 * </p>
 *
 * @author ultraman
 * @since 2020-12-02
 */
public enum EnableFlag {

    _0("0", "未启用"),
    _1("1", "已启用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;


    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnableFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

}
