package com.xforceplus.ultstatemachine.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 操作符
 * </p>
 *
 * @author ultraman
 * @since 2020-12-02
 */
public enum Operate {

    IN("in", "包含"),
    NOTIN("notin", "不包含");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;


    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Operate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

}
