package com.xforceplus.ultstatemachine.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发布状态
 * </p>
 *
 * @author ultraman
 * @since 2020-12-02
 */
public enum PublishFlag {

    _0("0", "未发布"),
    _1("1", "已发布"),
    _2("2", "已更新");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;


    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PublishFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

}
