package com.xforceplus.ultramanapi.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-05-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanapi.entity.ApiBaseInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-api")
public interface ApiBaseInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/apiBaseInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param apiBaseInfo ${table.comment}
   * @return R
   */
  @PostMapping("/apiBaseInfo/add")
  public R save(@RequestBody ApiBaseInfo apiBaseInfo);

  /**
   * 修改${table.comment}
   * @param apiBaseInfo ${table.comment}
   * @return R
   */
  @PostMapping("/apiBaseInfo/update")
  public R updateById(@RequestBody ApiBaseInfo apiBaseInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/apiBaseInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}