package com.xforceplus.ultramanapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * HTTP请求方式
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
public enum METHOD {

    GET("GET", "请求方式-GET"),
    POST("POST", "请求方式-POST"),
    PUT("PUT", "请求方式-PUT"),
    DELETE("DELETE", "请求方式-DELETE"),
    HEAD("HEAD", "请求方式-HEAD"),
    OPTIONS("OPTIONS", "请求方式-OPTIONS"),
    PATCH("PATCH", "请求方式-PATCH"),
    TRACE("TRACE", "请求方式-TRACE"),
    CONNECT("CONNECT", "请求方式-CONNECT");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    METHOD(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static METHOD fromCode(String code){
        switch(code) {
            case "GET":
                return GET;
            case "POST":
                return POST;
            case "PUT":
                return PUT;
            case "DELETE":
                return DELETE;
            case "HEAD":
                return HEAD;
            case "OPTIONS":
                return OPTIONS;
            case "PATCH":
                return PATCH;
            case "TRACE":
                return TRACE;
            case "CONNECT":
                return CONNECT;
            default:
                return null;
        }
    }
}
