package com.xforceplus.ultramanapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 值类型
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
public enum VALUETYPE {

    ARRAY("ARRAY", "数组"),
    OBJECT("OBJECT", "对象"),
    STRING("STRING", "字符串"),
    LONG("LONG", "长整型"),
    INTEGER("INTEGER", "整型"),
    DOUBLE("DOUBLE", "双精度浮点型"),
    FLOAT("FLOAT", "浮点型"),
    BOOLEAN("BOOLEAN", "布尔型");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VALUETYPE(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VALUETYPE fromCode(String code){
        switch(code) {
            case "ARRAY":
                return ARRAY;
            case "OBJECT":
                return OBJECT;
            case "STRING":
                return STRING;
            case "LONG":
                return LONG;
            case "INTEGER":
                return INTEGER;
            case "DOUBLE":
                return DOUBLE;
            case "FLOAT":
                return FLOAT;
            case "BOOLEAN":
                return BOOLEAN;
            default:
                return null;
        }
    }
}
