package com.xforceplus.ultramanapi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ApiBaseInfo implements Serializable {

  private static final long serialVersionUID=1L;

  private String applicationId;

  private String apiClassification;

  private String apiCode;

  private String apiName;

  private String resourceKey;

  private String apiVersion;

  private String url;

  private String method;

  private Boolean idempotent;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String applicationName;

  private String status;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("application_id", applicationId);
      map.put("api_classification", apiClassification);
      map.put("api_code", apiCode);
      map.put("api_name", apiName);
      map.put("resource_key", resourceKey);
      map.put("api_version", apiVersion);
      map.put("url", url);
      map.put("method", method);
      map.put("idempotent", idempotent);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("application_name", applicationName);
      map.put("status", status);
      map.put("tenant_code", tenantCode);
      return map;
  }

  public static ApiBaseInfo fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ApiBaseInfo entity = new ApiBaseInfo();
    if(map.containsKey("application_id")) {
      Object obj = map.get("application_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicationId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("api_classification")) {
      Object obj = map.get("api_classification");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApiClassification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("api_code")) {
      Object obj = map.get("api_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApiCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("api_name")) {
      Object obj = map.get("api_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApiName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("resource_key")) {
      Object obj = map.get("resource_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResourceKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("api_version")) {
      Object obj = map.get("api_version");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApiVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("method")) {
      Object obj = map.get("method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("idempotent")) {
      Object obj = map.get("idempotent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIdempotent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIdempotent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("application_name")) {
      Object obj = map.get("application_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
