package com.xforceplus.ultramanapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 状态
 * </p>
 *
 * @author ultraman
 * @since 2021-05-07
 */
public enum STATUS {

    ENABLE("ENABLE", "启用"),
    DISABLE("DISABLE", "停用"),
    INITIAL("INITIAL", "初始");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    STATUS(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static STATUS fromCode(String code){
        switch(code) {
            case "ENABLE":
                return ENABLE;
            case "DISABLE":
                return DISABLE;
            case "INITIAL":
                return INITIAL;
            default:
                return null;
        }
    }
}
