package com.xforceplus.ultramanapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanapi.entity.ApiBaseInfo;
import com.xforceplus.ultramanapi.service.IApiBaseInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-06
 */
@RestController
public class ApiBaseInfoController {

  @Autowired
  private IApiBaseInfoService apiBaseInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param apiBaseInfo ${table.comment}
   * @return
   */
  @GetMapping("/apibaseinfos" )
  public XfR getApiBaseInfos(XfPage page, ApiBaseInfo apiBaseInfo) {
    return XfR.ok(apiBaseInfoServiceImpl.page(page, Wrappers.query(apiBaseInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/apibaseinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(apiBaseInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param apiBaseInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/apibaseinfos")
  public XfR save(@RequestBody ApiBaseInfo apiBaseInfo) {
     return XfR.ok(apiBaseInfoServiceImpl.save(apiBaseInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param apiBaseInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/apibaseinfos/{id}")
  public XfR putUpdate(@RequestBody ApiBaseInfo apiBaseInfo,@PathVariable Long id) {
      apiBaseInfo.setId(id);
      return XfR.ok(apiBaseInfoServiceImpl.updateById(apiBaseInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param apiBaseInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/apibaseinfos/{id}")
  public XfR patchUpdate(@RequestBody ApiBaseInfo apiBaseInfo,@PathVariable Long id) {
      ApiBaseInfo upapiBaseInfo = apiBaseInfoServiceImpl.getById(id);
      if(upapiBaseInfo != null){
        upapiBaseInfo = ObjectCopyUtils.copyProperties(apiBaseInfo,upapiBaseInfo,true);
      }
      return XfR.ok(apiBaseInfoServiceImpl.updateById(upapiBaseInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apibaseinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(apiBaseInfoServiceImpl.removeById(id));
  }

  @PostMapping("/apibaseinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "apibaseinfo");
      params.put("request", condition);

     return XfR.ok(apiBaseInfoServiceImpl.querys(params));
  }

}
