package com.xforceplus.ultramanapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanapi.entity.ApiParamsInfo;
import com.xforceplus.ultramanapi.service.IApiParamsInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-06
 */
@RestController
public class ApiParamsInfoController {

  @Autowired
  private IApiParamsInfoService apiParamsInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param apiParamsInfo ${table.comment}
   * @return
   */
  @GetMapping("/apiparamsinfos" )
  public XfR getApiParamsInfos(XfPage page, ApiParamsInfo apiParamsInfo) {
    return XfR.ok(apiParamsInfoServiceImpl.page(page, Wrappers.query(apiParamsInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/apiparamsinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(apiParamsInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param apiParamsInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/apiparamsinfos")
  public XfR save(@RequestBody ApiParamsInfo apiParamsInfo) {
     return XfR.ok(apiParamsInfoServiceImpl.save(apiParamsInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param apiParamsInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/apiparamsinfos/{id}")
  public XfR putUpdate(@RequestBody ApiParamsInfo apiParamsInfo,@PathVariable Long id) {
      apiParamsInfo.setId(id);
      return XfR.ok(apiParamsInfoServiceImpl.updateById(apiParamsInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param apiParamsInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/apiparamsinfos/{id}")
  public XfR patchUpdate(@RequestBody ApiParamsInfo apiParamsInfo,@PathVariable Long id) {
      ApiParamsInfo upapiParamsInfo = apiParamsInfoServiceImpl.getById(id);
      if(upapiParamsInfo != null){
        upapiParamsInfo = ObjectCopyUtils.copyProperties(apiParamsInfo,upapiParamsInfo,true);
      }
      return XfR.ok(apiParamsInfoServiceImpl.updateById(upapiParamsInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apiparamsinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(apiParamsInfoServiceImpl.removeById(id));
  }

  @PostMapping("/apiparamsinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "apiparamsinfo");
      params.put("request", condition);

     return XfR.ok(apiParamsInfoServiceImpl.querys(params));
  }

}
