package com.xforceplus.ultramanbocp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发展状态
 * </p>
 *
 * @author ultraman
 * @since 2021-05-08
 */
public enum GrowState {

    STARTUP("startup", "初创"),
    SMALL("small", "小企业"),
    LARGE("large", "大企业");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    GrowState(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GrowState fromCode(String code){
        switch(code) {
            case "startup":
                return STARTUP;
            case "small":
                return SMALL;
            case "large":
                return LARGE;
            default:
                return null;
        }
    }
}
