package com.xforceplus.ultramanbocp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 消息范围
 * </p>
 *
 * @author ultraman
 * @since 2021-05-08
 */
public enum MessageScope {

    SINGLE("SINGLE", "个人消息"),
    APP_GLOBAL("APP_GLOBAL", "系统公告");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MessageScope(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MessageScope fromCode(String code){
        switch(code) {
            case "SINGLE":
                return SINGLE;
            case "APP_GLOBAL":
                return APP_GLOBAL;
            default:
                return null;
        }
    }
}
