package com.xforceplus.ultraman.bocp.gen.config;

import com.xforceplus.ultraman.bocp.gen.po.ModuleInfo;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApplicationConfig {
    private Long id;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 应用名称
     */
    private String name;

    /**
     * 应用别名 - 用于名称简写
     */
    private String alias;

    /**
     * 应用CODE
     */
    private String code;

    /**
     * 说明信息
     */
    private String remark;

    /**
     * 代码地址信息
     */
    private String url;

    /**
     * 版本信息
     */
    private String version;

    /**
     * 应用状态
     */
    private String status;

    /**
     * 创建用户
     */
    private Long createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新用户
     */
    private Long updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 删除标识
     */
    private String deleteFlag;

    /**
     * 应用service端
     */
    private String applicationService;

    /**
     * 应用客户端
     */
    private String applicationClient;

    /**
     * 应用下的模块信息
     */
    private List<ModuleInfo> moduleList;

}
