package com.xforceplus.ultraman.bocp.gen.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.querys.H2Query;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.xforceplus.ultraman.bocp.gen.po.BoGenField;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BocpConfigBuilder {

    /**
     * 项目相关配置
     */
    private ProjectConfig projectConfig;

    /**
     * 应用信息配置
     */
    private ApplicationConfig applicationConfig;
    /**
     * 模块相关配置
     */
    private ModuleConfig moduleConfig;

    /**
     * 业务对象相关配置
     */
    private BoConfig boConfig;
    /**
     * 字典对象相关配置
     */
    private DictConfig dictConfig;
    /**
     * DTO相关配置
     */
    private DtoConfig dtoConfig;
    /**
     * 模板路径配置信息
     */
    private BocpTemplateConfig bocpTemplate;

    /**
     * 数据库配置
     */
    private DataSourceConfig dataSourceConfig;
    /**
     * SQL连接
     */
    private Connection connection;
    /**
     * SQL语句类型
     */
    private IDbQuery dbQuery;
    private String superEntityClass;
    private String superMapperClass;
    private TableInfo baseEntity;
    /**
     * service超类定义
     */
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    /**
     * 数据库表信息
     */
    private List<TableInfo> tableInfoList;
    /**
     * 包配置详情
     */
    private Map<String, String> packageInfo;
    /**
     * 路径配置信息
     */
    private Map<String, String> pathInfo;
    /**
     * 策略配置
     */
    private StrategyConfig strategyConfig;
    /**
     * 全局配置信息
     */
    private GlobalConfig globalConfig;
    /**
     * 注入配置信息
     */
    private InjectionConfig injectionConfig;
    /**
     * 是否支持注释
     */
    private boolean commentSupported;

    /**
     * 在构造器中处理配置
     *
     * @param packageConfig    包配置
     * @param dataSourceConfig 数据源配置
     * @param strategyConfig   表配置
     * @param bocpTemplate     模板配置
     * @param globalConfig     全局配置
     */
    public BocpConfigBuilder(ProjectConfig projectConfig, ApplicationConfig applicationConfig, ModuleConfig moduleConfig, BoConfig boConfig, DictConfig dictConfig, DtoConfig dtoConfig,
                             PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig,
                             BocpTemplateConfig bocpTemplate, GlobalConfig globalConfig) {
        // 项目配置
        if (null == projectConfig) {
//            this.projectConfig = new ProjectConfig();
        } else {
            this.projectConfig = projectConfig;
        }
        // 应用配置
        if (null == applicationConfig) {
//            this.applicationConfig = new ApplicationConfig();
        } else {
            this.applicationConfig = applicationConfig;
        }

        // 应用配置
        if (null == moduleConfig) {
//            this.moduleConfig = new ModuleConfig();
        } else {
            this.moduleConfig = moduleConfig;
        }

        // 应用配置
        if (null == boConfig) {
//            this.boConfig = new BoConfig();
        } else {
            this.boConfig = boConfig;
        }

        // 字典配置
        if (null == dictConfig) {
//            this.dictConfig = new DictConfig();
        } else {
            this.dictConfig = dictConfig;
        }

        // DTO配置
        this.dtoConfig = dtoConfig;

        // 全局配置
        if (null == globalConfig) {
            this.globalConfig = new GlobalConfig();
        } else {
            this.globalConfig = globalConfig;
        }
        // 模板配置
        if (null == bocpTemplate) {
            this.bocpTemplate = new BocpTemplateConfig();
        } else {
            this.bocpTemplate = bocpTemplate;
        }
        // 包配置
        if (null == packageConfig) {
            handlerPackage(this.bocpTemplate, this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            handlerPackage(this.bocpTemplate, this.globalConfig.getOutputDir(), packageConfig);
        }
        // 策略配置
        if (null == strategyConfig) {
            this.strategyConfig = new StrategyConfig();
        } else {
            this.strategyConfig = strategyConfig;
        }
        this.dataSourceConfig = dataSourceConfig;
//        if(null != dataSourceConfig) {
//            handlerDataSource(dataSourceConfig);
//
//            //SQLITE 数据库不支持注释获取
//            commentSupported = !dataSourceConfig.getDbType().equals(DbType.SQLITE);
//        }
        if (null != boConfig) {
            if(boConfig.getFromDB() && this.dataSourceConfig != null){
                handlerDataSource(dataSourceConfig);
                //SQLITE 数据库不支持注释获取
                commentSupported = !dataSourceConfig.getDbType().equals(DbType.SQLITE);

                handlerStrategy(this.strategyConfig);
            }else {
                handlerStrategyByBo(this.strategyConfig, boConfig);
            }
        }
//        else {
//            handlerStrategy(this.strategyConfig);
//        }
    }

    // ************************ 曝露方法 BEGIN*****************************

    /**
     * 所有包配置信息
     *
     * @return 包配置
     */
    public Map<String, String> getPackageInfo() {
        return packageInfo;
    }


    /**
     * 所有路径配置
     *
     * @return 路径配置
     */
    public Map<String, String> getPathInfo() {
        return pathInfo;
    }


    public String getSuperEntityClass() {
        return superEntityClass;
    }


    public String getSuperMapperClass() {
        return superMapperClass;
    }


    /**
     * 获取超类定义
     *
     * @return 完整超类名称
     */
    public String getSuperServiceClass() {
        return superServiceClass;
    }


    public String getSuperServiceImplClass() {
        return superServiceImplClass;
    }


    public String getSuperControllerClass() {
        return superControllerClass;
    }


    /**
     * 表信息
     *
     * @return 所有表信息
     */
    public List<TableInfo> getTableInfoList() {
        return tableInfoList;
    }

    public BocpConfigBuilder setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
        return this;
    }


    /**
     * 模板路径配置信息
     *
     * @return 所以模板路径配置信息
     */
    public BocpTemplateConfig getBocpTemplate() {
        return bocpTemplate == null ? new BocpTemplateConfig() : bocpTemplate;
    }

    // ****************************** 曝露方法 END**********************************

    /**
     * 处理包配置
     *
     * @param bocpTemplate TemplateConfig
     * @param outputDir
     * @param config       PackageConfig
     */
    private void handlerPackage(BocpTemplateConfig bocpTemplate, String outputDir, PackageConfig config) {
        //初始化应用地址信息
        String projectPath = joinPackage(null, projectConfig.getName());
        String applicationPath = joinPackage(projectPath, applicationConfig.getName());
        String applicationServicePath = joinPackage(applicationPath, applicationConfig.getName() + BocpConstVal.SERVICE_SUFFIX);
        String applicationClientPath = joinPackage(applicationPath, applicationConfig.getName() + BocpConstVal.CLIENT_SUFFIX);
        String applicationClientMainPath = joinPackage(applicationServicePath, BocpConstVal.JAVA_SRC_PATH);
        String applicationClientResourcesPath = joinPackage(applicationClientPath, BocpConstVal.RESOURCES_SRC_PATH);
        String applicationClientPackegePath = joinPackage(applicationClientMainPath, config.getParent());
        String applicationServiceMainPath = joinPackage(applicationServicePath, BocpConstVal.JAVA_SRC_PATH);
        String applicationServiceResourcesPath = joinPackage(applicationServicePath, BocpConstVal.RESOURCES_SRC_PATH);
        String applicationServicePackegePath = joinPackage(applicationServiceMainPath, config.getParent());

        //模块地址信息
        String modulePath = joinPackage(projectPath, moduleConfig.getName());
        String moduleServicePath = joinPackage(modulePath, moduleConfig.getName() + BocpConstVal.SERVICE_SUFFIX);
        String moduleClientPath = joinPackage(modulePath, moduleConfig.getName() + BocpConstVal.CLIENT_SUFFIX);
        String moduleDomainPath = joinPackage(modulePath, moduleConfig.getName() + BocpConstVal.DOMAIN_SUFFIX);
        String moduleClientMainPath = joinPackage(moduleClientPath, BocpConstVal.JAVA_SRC_PATH);
        String moduleClientResourcesPath = joinPackage(moduleClientPath, BocpConstVal.RESOURCES_SRC_PATH);
        String moduleClientPackegePath = joinPackage(moduleClientMainPath, config.getParent());
        String moduleServiceMainPath = joinPackage(moduleServicePath, BocpConstVal.JAVA_SRC_PATH);
        String moduleServiceResourcesPath = joinPackage(moduleServicePath, BocpConstVal.RESOURCES_SRC_PATH);
        String moduleServicePackegePath = joinPackage(moduleServiceMainPath, config.getParent());
        String moduleDomainMainPath = joinPackage(moduleDomainPath, BocpConstVal.JAVA_SRC_PATH);
        String moduleDomainResourcesPath = joinPackage(moduleDomainMainPath, BocpConstVal.RESOURCES_SRC_PATH);
        String moduleDomainPackegePath = joinPackage(moduleDomainMainPath, config.getParent());

        //业务对象地址信息
//        String boPath = joinPackage(modulePath,boConfig.getName());

        // 包信息
        packageInfo = new HashMap<>(8);
        if (null != boConfig) {
            packageInfo.put(ConstVal.MODULE_NAME, config.getModuleName());
            packageInfo.put(ConstVal.ENTITY, joinPackage(moduleDomainPackegePath, config.getEntity()));
            packageInfo.put(ConstVal.MAPPER, joinPackage(moduleServicePackegePath, config.getMapper()));
            packageInfo.put(ConstVal.XML, joinPackage(moduleServiceResourcesPath, config.getXml()));
            packageInfo.put(ConstVal.SERVICE, joinPackage(moduleServicePackegePath, config.getService()));
            packageInfo.put(ConstVal.SERVICE_IMPL, joinPackage(moduleServicePackegePath, config.getServiceImpl()));
            packageInfo.put(ConstVal.CONTROLLER, joinPackage(moduleServicePackegePath, config.getController()));
            packageInfo.put(BocpConstVal.FEIGN, joinPackage(moduleClientPackegePath, config.getController()));

            packageInfo.put(BocpConstVal.ENTITY_PACKEGE, joinPackage(config.getParent(), config.getEntity()));
            packageInfo.put(BocpConstVal.MAPPER_PACKEGE, joinPackage(config.getParent(), config.getMapper()));
            packageInfo.put(BocpConstVal.XML_PACKEGE, joinPackage(config.getParent(), config.getXml()));
            packageInfo.put(BocpConstVal.SERVICE_PACKEGE, joinPackage(config.getParent(), config.getService()));
            packageInfo.put(BocpConstVal.SERVICE_IMPL_PACKEGE, joinPackage(config.getParent(), config.getServiceImpl()));
            packageInfo.put(BocpConstVal.CONTROLLER_PACKEGE, joinPackage(config.getParent(), config.getController()));
            packageInfo.put(BocpConstVal.FEIGN_PACKEGE, joinPackage(config.getParent(), config.getController()));

            packageInfo.put(ConstValEx.BASE_ENTITY, joinPackage(moduleDomainPackegePath, config.getEntity()));
        }

        if(dictConfig != null) {
            packageInfo.put(ConstValEx.ENUM, joinPackage(moduleDomainPackegePath, "dict"));
            packageInfo.put(BocpConstVal.DICT_PACKAGE, joinPackage(config.getParent(), "dict"));
        }

        if(dtoConfig != null) {
            packageInfo.put(BocpConstVal.DTO, joinPackage(moduleDomainPackegePath, "dto"));
            packageInfo.put(BocpConstVal.DTO_PACKAGE, joinPackage(config.getParent(), "dto"));
        }

        //应用目录
        if (null != applicationConfig.getName()) {
            packageInfo.put(BocpConstVal.PROJECT, projectPath);
            packageInfo.put(BocpConstVal.APPLICATION, applicationPath);
//            packageInfo.put(BocpConstVal.APPLICATION_CLIENT, applicationClientPath);
            packageInfo.put(BocpConstVal.APPLICATION_SERVICE, applicationServicePath);
            packageInfo.put(BocpConstVal.APPLICATION_SERVICE_PACKAGE, config.getParent());
            packageInfo.put(BocpConstVal.APPLICATION_YML, applicationServiceResourcesPath);
            packageInfo.put(BocpConstVal.SERVICE_APPLICATION, applicationServicePackegePath);
            packageInfo.put(BocpConstVal.SERVICE_APPLICATION_TESTS, applicationServicePackegePath);
        }

        //模块目录
        if (null != moduleConfig.getName()) {
            packageInfo.put(BocpConstVal.MODULE, modulePath);
            packageInfo.put(BocpConstVal.MODULE_CLIENT, moduleClientPath);
            packageInfo.put(BocpConstVal.MODULE_SERVICE, moduleServicePath);
            packageInfo.put(BocpConstVal.MODULE_DOMAIN, moduleDomainPath);
            packageInfo.put(BocpConstVal.MODULE_SERVICE_PACKAGE, config.getParent());
            packageInfo.put(BocpConstVal.MODULE_APPLICATION_YML, moduleServiceResourcesPath);
            packageInfo.put(BocpConstVal.MODULE_SERVICE_APPLICATION, moduleServicePackegePath);
        }

        // 自定义路径
        Map<String, String> configPathInfo = config.getPathInfo();
        if (null != configPathInfo) {
            pathInfo = configPathInfo;
        } else {
            // 生成路径信息
            pathInfo = new HashMap<>(6);
            if (null != boConfig) {
                setPathInfo(pathInfo, bocpTemplate.getEntity(getGlobalConfig().isKotlin()), outputDir, ConstVal.ENTITY_PATH, ConstVal.ENTITY);
                setPathInfo(pathInfo, bocpTemplate.getMapper(), outputDir, ConstVal.MAPPER_PATH, ConstVal.MAPPER);
                setPathInfo(pathInfo, bocpTemplate.getXml(), outputDir, ConstVal.XML_PATH, ConstVal.XML);
                setPathInfo(pathInfo, bocpTemplate.getService(), outputDir, ConstVal.SERVICE_PATH, ConstVal.SERVICE);
                setPathInfo(pathInfo, bocpTemplate.getServiceImpl(), outputDir, ConstVal.SERVICE_IMPL_PATH, ConstVal.SERVICE_IMPL);
                setPathInfo(pathInfo, bocpTemplate.getController(), outputDir, ConstVal.CONTROLLER_PATH, ConstVal.CONTROLLER);
                setPathInfo(pathInfo, bocpTemplate.getFeign(), outputDir, BocpConstVal.FEIGN_PATH, BocpConstVal.FEIGN);

                setPathInfo(pathInfo, bocpTemplate.getBaseEntity(getGlobalConfig().isKotlin()), outputDir, ConstValEx.BASE_ENTITY_PATH, ConstValEx.BASE_ENTITY);
            }
            if(null != dictConfig) {
                setPathInfo(pathInfo, bocpTemplate.getEnum(getGlobalConfig().isKotlin()), outputDir, ConstValEx.ENUM_PATH, ConstValEx.ENUM);
            }
            if(null != dtoConfig) {
                setPathInfo(pathInfo, bocpTemplate.getDto(getGlobalConfig().isKotlin()), outputDir, BocpConstVal.DTO_PATH, BocpConstVal.DTO);
            }
            //应用目录
            if (null != applicationConfig.getName()) {
                setPathInfo(pathInfo, bocpTemplate.getApplicationParentPom(), outputDir, BocpConstVal.PARENT_POM_PATH, BocpConstVal.PROJECT);
                setPathInfo(pathInfo, bocpTemplate.getGitignore(), outputDir, BocpConstVal.GITIGNORE_PATH, BocpConstVal.APPLICATION);
                setPathInfo(pathInfo, bocpTemplate.getGitlab(), outputDir, BocpConstVal.GITLAB_PATH, BocpConstVal.APPLICATION);
                setPathInfo(pathInfo, bocpTemplate.getApplicationPom(), outputDir, BocpConstVal.POM_PATH, BocpConstVal.APPLICATION);
//                setPathInfo(pathInfo, bocpTemplate.getClientPom(), outputDir, BocpConstVal.CLIENT_POM_PATH, BocpConstVal.APPLICATION_CLIENT);
                setPathInfo(pathInfo, bocpTemplate.getApplicationYml(), outputDir, BocpConstVal.APPLICATION_YML_PATH, BocpConstVal.APPLICATION_YML);
                setPathInfo(pathInfo, bocpTemplate.getServicePom(), outputDir, BocpConstVal.SERVICE_POM_PATH, BocpConstVal.APPLICATION_SERVICE);
                setPathInfo(pathInfo, bocpTemplate.getServiceApplication(), outputDir, BocpConstVal.SERVICE_APPLICATION_PATH, BocpConstVal.SERVICE_APPLICATION);
                setPathInfo(pathInfo, bocpTemplate.getServiceApplicationTest(), outputDir, BocpConstVal.SERVICE_APPLICATION_TESTS_PATH, BocpConstVal.SERVICE_APPLICATION_TESTS);
            }
            //模块目录
            if (null != moduleConfig.getName()) {
                setPathInfo(pathInfo, bocpTemplate.getModuleParentPom(), outputDir, BocpConstVal.MODULE_PARENT_POM_PATH, BocpConstVal.PROJECT);
                setPathInfo(pathInfo, bocpTemplate.getModuleGitignore(), outputDir, BocpConstVal.MODULE_GITIGNORE_PATH, BocpConstVal.MODULE);
                setPathInfo(pathInfo, bocpTemplate.getModuleGitlab(), outputDir, BocpConstVal.MODULE_GITLAB_PATH, BocpConstVal.MODULE);
                setPathInfo(pathInfo, bocpTemplate.getModulePom(), outputDir, BocpConstVal.MODULE_POM_PATH, BocpConstVal.MODULE);
                setPathInfo(pathInfo, bocpTemplate.getModuleClientPom(), outputDir, BocpConstVal.MODULE_CLIENT_POM_PATH, BocpConstVal.MODULE_CLIENT);
                setPathInfo(pathInfo, bocpTemplate.getModuleApplicationYml(), outputDir, BocpConstVal.MODULE_APPLICATION_YML_PATH, BocpConstVal.MODULE_APPLICATION_YML);
                setPathInfo(pathInfo, bocpTemplate.getModuleServicePom(), outputDir, BocpConstVal.MODULE_SERVICE_POM_PATH, BocpConstVal.MODULE_SERVICE);
                setPathInfo(pathInfo, bocpTemplate.getModuleServicePom(), outputDir, BocpConstVal.MODULE_DOMAIN_POM_PATH, BocpConstVal.MODULE_DOMAIN);
                setPathInfo(pathInfo, bocpTemplate.getModuleServiceApplication(), outputDir, BocpConstVal.MODULE_SERVICE_APPLICATION_PATH, BocpConstVal.MODULE_SERVICE_APPLICATION);
            }
        }

    }

    private void setPathInfo(Map<String, String> pathInfo, String bocpTemplate, String outputDir, String path, String module) {
        if (StringUtils.isNotEmpty(bocpTemplate)) {
            pathInfo.put(path, joinPath(outputDir, packageInfo.get(module)));
        }
    }

//    private void handlerPorjectConfig(String outputDir, ProjectConfig config){
//
//    }
//    private void handlerApplicationConfig(String outputDir, ApplicationConfig config){
//
//    }

    /**
     * 处理数据源配置
     *
     * @param config DataSourceConfig
     */
    private void handlerDataSource(DataSourceConfig config) {
        connection = config.getConn();
        dbQuery = config.getDbQuery();
    }


    /**
     * 处理数据库表 加载数据库表、列、注释相关数据集
     *
     * @param config StrategyConfig
     */
    private void handlerStrategy(StrategyConfig config) {
        processTypes(config);
        tableInfoList = getTablesInfo(config);
    }

    /**
     * 基于BO信息扩展的生成方式，将BO信息处理成TableInfo
     * @param config
     * @param boConfig
     */
    private void handlerStrategyByBo(StrategyConfig config,BoConfig boConfig) {
        processTypes(config);
        tableInfoList = getTablesInfoByBo(config,boConfig);
        if(boConfig.getBaseEntity() != null) {
            baseEntity = buildTableInfo(config, boConfig.getBaseEntity());
            nameConvert(baseEntity, config.getNaming(), config.getTablePrefix());
        }
    }

    /**
     * 处理superClassName,IdClassType,IdStrategy配置
     *
     * @param config 策略配置
     */
    private void processTypes(StrategyConfig config) {
        if (StringUtils.isEmpty(config.getSuperServiceClass())) {
            superServiceClass = ConstVal.SUPER_SERVICE_CLASS;
        } else {
            superServiceClass = config.getSuperServiceClass();
        }
        if (StringUtils.isEmpty(config.getSuperServiceImplClass())) {
            superServiceImplClass = ConstVal.SUPER_SERVICE_IMPL_CLASS;
        } else {
            superServiceImplClass = config.getSuperServiceImplClass();
        }
        if (StringUtils.isEmpty(config.getSuperMapperClass())) {
            superMapperClass = ConstVal.SUPER_MAPPER_CLASS;
        } else {
            superMapperClass = config.getSuperMapperClass();
        }
        superEntityClass = config.getSuperEntityClass();
        superControllerClass = config.getSuperControllerClass();
    }


    /**
     * 处理表对应的类名称
     *
     * @param tableList 表名称
     * @param strategy  命名策略
     * @param config    策略配置项
     * @return 补充完整信息后的表
     */
    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, StrategyConfig config) {
        String[] tablePrefix = config.getTablePrefix();
        for (TableInfo tableInfo : tableList) {
            nameConvert(tableInfo, strategy, tablePrefix);
            // 检测导入包
            checkImportPackages(tableInfo);
        }
        return tableList;
    }

    private void nameConvert(TableInfo tableInfo, NamingStrategy strategy, String[] tablePrefix) {
        String entityName;
        INameConvert nameConvert = strategyConfig.getNameConvert();
        if (null != nameConvert) {
            // 自定义处理实体名称
            entityName = NamingStrategy.capitalFirst(processName(nameConvert.entityNameConvert(tableInfo), strategy, tablePrefix));
        } else {
            entityName = NamingStrategy.capitalFirst(processName(tableInfo.getName(), strategy, tablePrefix));
        }
        if (StringUtils.isNotEmpty(globalConfig.getEntityName())) {
            tableInfo.setConvert(true);
            tableInfo.setEntityName(String.format(globalConfig.getEntityName(), entityName));
        } else {
            tableInfo.setEntityName(strategyConfig, entityName);
        }
        if (StringUtils.isNotEmpty(globalConfig.getMapperName())) {
            tableInfo.setMapperName(String.format(globalConfig.getMapperName(), entityName));
        } else {
            tableInfo.setMapperName(entityName + ConstVal.MAPPER);
        }
        if (StringUtils.isNotEmpty(globalConfig.getXmlName())) {
            tableInfo.setXmlName(String.format(globalConfig.getXmlName(), entityName));
        } else {
            tableInfo.setXmlName(entityName + ConstVal.MAPPER);
        }
        if (StringUtils.isNotEmpty(globalConfig.getServiceName())) {
            tableInfo.setServiceName(String.format(globalConfig.getServiceName(), entityName));
        } else {
            tableInfo.setServiceName("I" + entityName + ConstVal.SERVICE);
        }
        if (StringUtils.isNotEmpty(globalConfig.getServiceImplName())) {
            tableInfo.setServiceImplName(String.format(globalConfig.getServiceImplName(), entityName));
        } else {
            tableInfo.setServiceImplName(entityName + ConstVal.SERVICE_IMPL);
        }
        if (StringUtils.isNotEmpty(globalConfig.getControllerName())) {
            tableInfo.setControllerName(String.format(globalConfig.getControllerName(), entityName));
        } else {
            tableInfo.setControllerName(entityName + ConstVal.CONTROLLER);
        }
    }

    /**
     * 检测导入包
     *
     * @param tableInfo ignore
     */
    private void checkImportPackages(TableInfo tableInfo) {
        if (StringUtils.isNotEmpty(strategyConfig.getSuperEntityClass())) {
            // 自定义父类
            tableInfo.getImportPackages().add(strategyConfig.getSuperEntityClass());
        } else if (globalConfig.isActiveRecord()) {
            // 无父类开启 AR 模式
            tableInfo.getImportPackages().add(com.baomidou.mybatisplus.extension.activerecord.Model.class.getCanonicalName());
        }
        if (null != globalConfig.getIdType()) {
            // 指定需要 IdType 场景
            tableInfo.getImportPackages().add(com.baomidou.mybatisplus.annotation.IdType.class.getCanonicalName());
            tableInfo.getImportPackages().add(com.baomidou.mybatisplus.annotation.TableId.class.getCanonicalName());
        }
        if (StringUtils.isNotEmpty(strategyConfig.getVersionFieldName())) {
            tableInfo.getFields().forEach(f -> {
                if (strategyConfig.getVersionFieldName().equals(f.getName())) {
                    tableInfo.getImportPackages().add(com.baomidou.mybatisplus.annotation.Version.class.getCanonicalName());
                }
            });
        }
    }

    /**
     * 根据业务对象转变成tableInfo
     */
    private List<TableInfo> getTablesInfoByBo(StrategyConfig config, BoConfig boConfig) {
        if(boConfig.getBoGenInfoList() == null) {
            return new ArrayList<>();
        }

        boolean isInclude = (null != config.getInclude() && config.getInclude().length > 0);
        boolean isExclude = (null != config.getExclude() && config.getExclude().length > 0);
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> 标签中 <include> 与 <exclude> 只能配置一项！");
        }
        //所有的表信息
        List<TableInfo> tableList = new ArrayList<>();

        //需要反向生成或排除的表信息
        List<TableInfo> includeTableList = new ArrayList<>();
        List<TableInfo> excludeTableList = new ArrayList<>();

        //不存在的表名
        Set<String> notExistTables = new HashSet<>();
        TableInfo tableInfo;
        for (BoGenInfo bo : boConfig.getBoGenInfoList()) {
            tableInfo = buildTableInfo(config, bo);
            tableList.add(tableInfo);
        }
        return processTable(tableList, config.getNaming(), config);
    }

    private TableInfo buildTableInfo(StrategyConfig config, BoGenInfo bo){
        TableInfo tableInfo;
        tableInfo = new TableInfo();
        tableInfo.setName(bo.getName());
        tableInfo.setComment(bo.getRemark());
        List<TableField> fieldList = new ArrayList<>();
        List<TableField> commonFieldList = new ArrayList<>();
        for (BoGenField boGenField : bo.getBoGenFieldList()) {
            TableField field = new TableField();
            String columnName = boGenField.getName();
            if (boGenField.getFieldKey() != null && "1".equals(boGenField.getFieldKey())) {
                field.setKeyIdentityFlag(true);
            } else {
                field.setKeyFlag(false);
            }
            field.setName(columnName);
            field.setType(boGenField.getFiledType());
            INameConvert nameConvert = strategyConfig.getNameConvert();
            if (null != nameConvert) {
//                    field.setPropertyName(nameConvert.propertyNameConvert(field));
                field.setPropertyName(strategyConfig, processName(nameConvert.propertyNameConvert(field), config.getNaming()));
            } else {
                field.setPropertyName(strategyConfig, processName(field.getName(), config.getNaming()));
            }
            if(null != dataSourceConfig) {
                field.setColumnType(dataSourceConfig.getTypeConvert().processTypeConvert(globalConfig, field));
            }
            if (commentSupported) {
                field.setComment(boGenField.getRemark());
            }
            if ("entity".equals(bo.getBoType()) && strategyConfig.includeSuperEntityColumns(field.getName())) {
                // 跳过公共字段
                commonFieldList.add(field);
                continue;
            }
            // 填充逻辑判断
            List<TableFill> tableFillList = getStrategyConfig().getTableFillList();
            if (null != tableFillList) {
                // 忽略大写字段问题
                tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName()))
                        .findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
            }
            fieldList.add(field);
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);

        return tableInfo;
    }

    /**
     * 获取所有的数据库表信息
     */
    private List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isInclude = (null != config.getInclude() && config.getInclude().length > 0);
        boolean isExclude = (null != config.getExclude() && config.getExclude().length > 0);
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> 标签中 <include> 与 <exclude> 只能配置一项！");
        }
        //所有的表信息
        List<TableInfo> tableList = new ArrayList<>();

        //需要反向生成或排除的表信息
        List<TableInfo> includeTableList = new ArrayList<>();
        List<TableInfo> excludeTableList = new ArrayList<>();

        //不存在的表名
        Set<String> notExistTables = new HashSet<>();
        try {
            String tablesSql = dbQuery.tablesSql();
            if (DbType.POSTGRE_SQL == dbQuery.dbType()) {
                String schema = dataSourceConfig.getSchemaName();
                if (schema == null) {
                    //pg 默认 schema=public
                    schema = "public";
                    dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            }
            if (DbType.DB2 == dbQuery.dbType()) {
                String schema = dataSourceConfig.getSchemaName();
                if (schema == null) {
                    //db2 默认 schema=current schema
                    schema = "current schema";
                    dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            }
            //oracle数据库表太多，出现最大游标错误
            else if (DbType.ORACLE == dbQuery.dbType()) {
                String schema = dataSourceConfig.getSchemaName();
                //oracle 默认 schema=username
                if (schema == null) {
                    schema = dataSourceConfig.getUsername().toUpperCase();
                    dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
                if (isInclude) {
                    StringBuilder sb = new StringBuilder(tablesSql);
                    sb.append(" AND ").append(dbQuery.tableName()).append(" IN (");
                    Arrays.stream(config.getInclude()).forEach(tbname -> sb.append(StringPool.SINGLE_QUOTE).append(tbname.toUpperCase()).append("',"));
                    sb.replace(sb.length() - 1, sb.length(), StringPool.RIGHT_BRACKET);
                    tablesSql = sb.toString();
                } else if (isExclude) {
                    StringBuilder sb = new StringBuilder(tablesSql);
                    sb.append(" AND ").append(dbQuery.tableName()).append(" NOT IN (");
                    Arrays.stream(config.getExclude()).forEach(tbname -> sb.append(StringPool.SINGLE_QUOTE).append(tbname.toUpperCase()).append("',"));
                    sb.replace(sb.length() - 1, sb.length(), StringPool.RIGHT_BRACKET);
                    tablesSql = sb.toString();
                }
            }
            TableInfo tableInfo;
            try (PreparedStatement preparedStatement = connection.prepareStatement(tablesSql);
                 ResultSet results = preparedStatement.executeQuery()) {
                while (results.next()) {
                    String tableName = results.getString(dbQuery.tableName());
                    if (StringUtils.isNotEmpty(tableName)) {
                        tableInfo = new TableInfo();
                        tableInfo.setName(tableName);

                        if (commentSupported) {
                            String tableComment = results.getString(dbQuery.tableComment());
                            if (config.isSkipView() && "VIEW".equals(tableComment)) {
                                // 跳过视图
                                continue;
                            }
                            tableInfo.setComment(tableComment);
                        }

                        if (isInclude) {
                            for (String includeTable : config.getInclude()) {
                                // 忽略大小写等于 或 正则 true
                                if (tableNameMatches(includeTable, tableName)) {
                                    includeTableList.add(tableInfo);
                                } else {
                                    notExistTables.add(includeTable);
                                }
                            }
                        } else if (isExclude) {
                            for (String excludeTable : config.getExclude()) {
                                // 忽略大小写等于 或 正则 true
                                if (tableNameMatches(excludeTable, tableName)) {
                                    excludeTableList.add(tableInfo);
                                } else {
                                    notExistTables.add(excludeTable);
                                }
                            }
                        }
                        tableList.add(tableInfo);
                    } else {
                        System.err.println("当前数据库为空！！！");
                    }
                }
            }
            // 将已经存在的表移除，获取配置中数据库不存在的表
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("表 " + notExistTables + " 在数据库中不存在！！！");
            }

            // 需要反向生成的表信息
            if (isExclude) {
                tableList.removeAll(excludeTableList);
                includeTableList = tableList;
            }
            if (!isInclude && !isExclude) {
                includeTableList = tableList;
            }
            // 性能优化，只处理需执行表字段 github issues/219
            includeTableList.forEach(ti -> convertTableFields(ti, config));
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return processTable(includeTableList, config.getNaming(), config);
    }


    /**
     * 表名匹配
     *
     * @param setTableName 设置表名
     * @param dbTableName  数据库表单
     * @return ignore
     */
    private boolean tableNameMatches(String setTableName, String dbTableName) {
        return setTableName.equalsIgnoreCase(dbTableName)
                || StringUtils.matches(setTableName, dbTableName);
    }

    /**
     * 将字段信息与表信息关联
     *
     * @param tableInfo 表信息
     * @param config    命名策略
     * @return ignore
     */
    private TableInfo convertTableFields(TableInfo tableInfo, StrategyConfig config) {
        boolean haveId = false;
        List<TableField> fieldList = new ArrayList<>();
        List<TableField> commonFieldList = new ArrayList<>();
        DbType dbType = dbQuery.dbType();
        String tableName = tableInfo.getName();
        try {
            String tableFieldsSql = dbQuery.tableFieldsSql();
            Set<String> h2PkColumns = new HashSet<>();
            if (DbType.POSTGRE_SQL == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.DB2 == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.ORACLE == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql.replace("#schema", dataSourceConfig.getSchemaName()), tableName);
            } else if (DbType.DM == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else if (DbType.H2 == dbType) {
                tableName = tableName.toUpperCase();
                try (PreparedStatement pkQueryStmt = connection.prepareStatement(String.format(H2Query.PK_QUERY_SQL, tableName));
                     ResultSet pkResults = pkQueryStmt.executeQuery()) {
                    while (pkResults.next()) {
                        String primaryKey = pkResults.getString(dbQuery.fieldKey());
                        if (Boolean.valueOf(primaryKey)) {
                            h2PkColumns.add(pkResults.getString(dbQuery.fieldName()));
                        }
                    }
                }
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else {
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            }
            try (
                    PreparedStatement preparedStatement = connection.prepareStatement(tableFieldsSql);
                    ResultSet results = preparedStatement.executeQuery()) {
                while (results.next()) {
                    TableField field = new TableField();
                    String columnName = results.getString(dbQuery.fieldName());
                    // 避免多重主键设置，目前只取第一个找到ID，并放到list中的索引为0的位置
                    boolean isId;
                    if (DbType.H2 == dbType) {
                        isId = h2PkColumns.contains(columnName);
                    } else {
                        String key = results.getString(dbQuery.fieldKey());
                        if (DbType.DB2 == dbType || DbType.SQLITE == dbType) {
                            isId = StringUtils.isNotEmpty(key) && "1".equals(key);
                        } else {
                            isId = StringUtils.isNotEmpty(key) && "PRI".equals(key.toUpperCase());
                        }
                    }

                    // 处理ID
                    if (isId && !haveId) {
                        field.setKeyFlag(true);
                        if (DbType.H2 == dbType || DbType.SQLITE == dbType || dbQuery.isKeyIdentity(results)) {
                            field.setKeyIdentityFlag(true);
                        }
                        haveId = true;
                    } else {
                        field.setKeyFlag(false);
                    }
                    // 自定义字段查询
                    String[] fcs = dbQuery.fieldCustom();
                    if (null != fcs) {
                        Map<String, Object> customMap = new HashMap<>(fcs.length);
                        for (String fc : fcs) {
                            customMap.put(fc, results.getObject(fc));
                        }
                        field.setCustomMap(customMap);
                    }
                    // 处理其它信息
                    field.setName(columnName);
                    field.setType(results.getString(dbQuery.fieldType()));
                    INameConvert nameConvert = strategyConfig.getNameConvert();
                    if (null != nameConvert) {
//                        field.setPropertyName(nameConvert.propertyNameConvert(field));
                        field.setPropertyName(strategyConfig, processName(nameConvert.propertyNameConvert(field), config.getNaming()));
                    } else {
                        field.setPropertyName(strategyConfig, processName(field.getName(), config.getNaming()));
                    }
                    if(null != dataSourceConfig) {
                        field.setColumnType(dataSourceConfig.getTypeConvert().processTypeConvert(globalConfig, field));
                    }
                    if (commentSupported) {
                        field.setComment(results.getString(dbQuery.fieldComment()));
                    }
                    if (strategyConfig.includeSuperEntityColumns(field.getName())) {
                        // 跳过公共字段
                        commonFieldList.add(field);
                        continue;
                    }
                    // 填充逻辑判断
                    List<TableFill> tableFillList = getStrategyConfig().getTableFillList();
                    if (null != tableFillList) {
                        // 忽略大写字段问题
                        tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName()))
                                .findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
                    }
                    fieldList.add(field);
                }
            }
        } catch (SQLException e) {
            System.err.println("SQL Exception：" + e.getMessage());
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);
        return tableInfo;
    }


    /**
     * 连接路径字符串
     *
     * @param parentDir   路径常量字符串
     * @param packageName 包名
     * @return 连接后的路径
     */
    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isEmpty(parentDir)) {
            parentDir = System.getProperty(ConstVal.JAVA_TMPDIR);
        }
        if (!StringUtils.endsWith(parentDir, File.separator)) {
            parentDir += File.separator;
        }
        packageName = packageName.replaceAll("\\.", StringPool.BACK_SLASH + File.separator);
        return parentDir + packageName;
    }

    /**
     * 连接父子包名
     *
     * @param parent     父包名
     * @param subPackage 子包名
     * @return 连接后的包名
     */
    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty(parent)) {
            return subPackage;
        }
        return parent + StringPool.DOT + subPackage;
    }


    /**
     * 处理字段名称
     *
     * @return 根据策略返回处理后的名称
     */
    private String processName(String name, NamingStrategy strategy) {
        return processName(name, strategy, strategyConfig.getFieldPrefix());
    }


    /**
     * 处理表/字段名称
     *
     * @param name     ignore
     * @param strategy ignore
     * @param prefix   ignore
     * @return 根据策略返回处理后的名称
     */
    private String processName(String name, NamingStrategy strategy, String[] prefix) {
        boolean removePrefix = false;
        if (prefix != null && prefix.length != 0) {
            removePrefix = true;
        }
        String propertyName;
        if (removePrefix) {
            if (strategy == NamingStrategy.underline_to_camel) {
                // 删除前缀、下划线转驼峰
                propertyName = NamingStrategy.removePrefixAndCamel(name, prefix);
            } else {
                // 删除前缀
                propertyName = NamingStrategy.removePrefix(name, prefix);
            }
        } else if (strategy == NamingStrategy.underline_to_camel) {
            // 下划线转驼峰
            propertyName = NamingStrategy.underlineToCamel(name);
        } else {
            // 不处理
            propertyName = name;
        }
        return propertyName;
    }


    public StrategyConfig getStrategyConfig() {
        return strategyConfig;
    }


    public BocpConfigBuilder setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
        return this;
    }


    public GlobalConfig getGlobalConfig() {
        return globalConfig;
    }


    public BocpConfigBuilder setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public InjectionConfig getInjectionConfig() {
        return injectionConfig;
    }


    public BocpConfigBuilder setInjectionConfig(InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    public ProjectConfig getProjectConfig() {
        return projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public ApplicationConfig getApplicationConfig() {
        return applicationConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public ModuleConfig getModuleConfig() {
        return moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public BoConfig getBoConfig() {
        return boConfig;
    }

    public void setBoConfig(BoConfig boConfig) {
        this.boConfig = boConfig;
    }

    public DataSourceConfig getDataSourceConfig() {
        return dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public TableInfo getBaseEntity() {
        return baseEntity;
    }

    public void setBaseEntity(TableInfo baseEntity) {
        this.baseEntity = baseEntity;
    }

    public DictConfig getDictConfig() {
        return dictConfig;
    }

    public void setDictConfig(DictConfig dictConfig) {
        this.dictConfig = dictConfig;
    }

    public DtoConfig getDtoConfig() {
        return dtoConfig;
    }

    public void setDtoConfig(DtoConfig dtoConfig) {
        this.dtoConfig = dtoConfig;
    }
}
