package com.xforceplus.ultraman.bocp.gen.config;

import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Slf4j
public class NameConvert implements INameConvert {

    public List names = new ArrayList<>();

    public NameConvert(){
        names.add("create_time");
        names.add("update_time");
        names.add("delete_flag");
        names.add("create_user");
        names.add("update_user");
        names.add("create_user_name");
        names.add("update_user_name");
        names.add("create_user_id");
        names.add("update_user_id");
        names.add("tenant_id");
        names.add("tenant_code");
    }

    @Override
    public String entityNameConvert(TableInfo tableInfo) {
        return tableInfo.getName();
    }

    @Override
    public String propertyNameConvert(TableField field) {
        log.info(field.getName());
        if (names.contains(field.getName())){
//            field.setConvert(false);

            if (Arrays.asList("update_time", "update_user", "update_user_id", "update_user_name").contains(field.getName())) {
                field.setFill("INSERT_UPDATE");
            }else {
                field.setFill("INSERT");
            }
        }
        return field.getName();
    }
}
