package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.ConstValEx;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.DictGenInfo;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.*;

public class DictVelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(DictVelocityTemplateEngine.class);
    private static final String DOT_VM = ".vm";
    private VelocityEngine velocityEngine;

    /**
     * 配置信息
     */
    private BocpConfigBuilder bocpConfigBuilder;

    /**
     * 模板引擎初始化
     */
    public DictVelocityTemplateEngine init(BocpConfigBuilder bocpConfigBuilder) {
        this.bocpConfigBuilder = bocpConfigBuilder;
        if (null == velocityEngine) {
            Properties p = new Properties();
            p.setProperty(ConstVal.VM_LOAD_PATH_KEY, ConstVal.VM_LOAD_PATH_VALUE);
            p.setProperty(Velocity.FILE_RESOURCE_LOADER_PATH, StringPool.EMPTY);
            p.setProperty(Velocity.ENCODING_DEFAULT, ConstVal.UTF8);
            p.setProperty(Velocity.INPUT_ENCODING, ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", StringPool.TRUE);
            velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isEmpty(templatePath)) {
            return;
        }

        Template template = velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter(fos, ConstVal.UTF8);
             BufferedWriter writer = new BufferedWriter(ow)) {
            template.merge(new VelocityContext(objectMap), writer);
        }
        System.out.println("模板:" + templatePath + ";  文件:" + outputFile);
        logger.debug("模板:" + templatePath + ";  文件:" + outputFile);
    }

    public String templateFilePath(String filePath) {
        if (null == filePath || filePath.contains(DOT_VM)) {
            return filePath;
        }
        return filePath + DOT_VM;
    }

    /**
     * 输出 java xml 文件
     */
    public DictVelocityTemplateEngine batchOutput() {
        try {
            List<DictGenInfo> dictGenInfos = getBocpConfigBuilder().getDictConfig().getDictGenInfos();
            for (DictGenInfo dictGenInfo : dictGenInfos) {
                Map<String, Object> objectMap = getObjectMap(dictGenInfo);
                Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
                // *Dict.java
                if (null != dictGenInfo.getCode() && null != pathInfo.get(ConstValEx.ENUM_PATH)) {
                    String entityFile = String.format((pathInfo.get(ConstValEx.ENUM_PATH) + File.separator + "%s" + suffixJavaOrKt()), dictGenInfo.getCode());
                    writer(objectMap, templateFilePath(template.getEnum(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                }
            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 处理输出目录
     */
    public DictVelocityTemplateEngine mkdirs() {
        getBocpConfigBuilder().getPathInfo().forEach((key, value) -> {
            File dir = new File(value);
            if (!dir.exists()) {
                boolean result = dir.mkdirs();
                if (result) {
                    logger.debug("创建目录： [" + value + "]");
                }
            }
        });
        return this;
    }


    /**
     * 打开输出目录
     */
    public void open() {
        String outDir = getBocpConfigBuilder().getGlobalConfig().getOutputDir();
        if (getBocpConfigBuilder().getGlobalConfig().isOpen()
                && StringUtils.isNotEmpty(outDir)) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + outDir);
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + outDir);
                    } else {
                        logger.debug("文件输出目录:" + outDir);
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    /**
     * 渲染对象 MAP 信息
     *
     * @param dictGenInfo 字典信息
     * @return ignore
     */
    public Map<String, Object> getObjectMap(DictGenInfo dictGenInfo) {
        Map<String, Object> objectMap = new HashMap<>(30);
        BocpConfigBuilder config = getBocpConfigBuilder();
        //将参数放入map中用于模板解析
        objectMap.put("restControllerStyle", config.getStrategyConfig().isRestControllerStyle());
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("dict", dictGenInfo);

        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    /**
     * 对象固定Id
     */
    private String getBoId(BocpConfigBuilder config, String boName) {
        List<BoGenInfo> boGenInfos = config.getBoConfig().getBoGenInfoList();
        Optional<BoGenInfo> optional = boGenInfos.stream()
                .filter(boGenInfo -> boGenInfo.getName().equals(boName)).findFirst();
        Long id = null;
        if (optional.isPresent()) {
            id = optional.get().getId();
        }
        return id == null ? "" : id.toString();
    }

    /**
     * 获取类名
     *
     * @param classPath ignore
     * @return ignore
     */
    private String getSuperClassName(String classPath) {
        if (StringUtils.isEmpty(classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(StringPool.DOT) + 1);
    }


    /**
     * 检测文件是否存在
     *
     * @return 文件是否存在
     */
    protected boolean isCreate(FileType fileType, String filePath) {
        BocpConfigBuilder cb = getBocpConfigBuilder();
        // 全局判断【默认】
        File file = new File(filePath);
        boolean exist = file.exists();
        if (!exist) {
            file.getParentFile().mkdirs();
        }
        return !exist || getBocpConfigBuilder().getGlobalConfig().isFileOverride();
    }

    /**
     * 文件后缀
     */
    protected String suffixJavaOrKt() {
        return getBocpConfigBuilder().getGlobalConfig().isKotlin() ? ConstVal.KT_SUFFIX : ConstVal.JAVA_SUFFIX;
    }


    public BocpConfigBuilder getBocpConfigBuilder() {
        return bocpConfigBuilder;
    }

    public void setBocpConfigBuilder(BocpConfigBuilder bocpConfigBuilder) {
        this.bocpConfigBuilder = bocpConfigBuilder;
    }
}
