package com.xforceplus.ultraman.bocp.gen.generator;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.*;
import com.xforceplus.ultraman.bocp.gen.engine.*;
import com.xforceplus.ultraman.bocp.gen.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class BocpAutoGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BocpAutoGenerator.class);

    /**
     * 模板 相关配置
     */
    private BocpTemplateConfig template;
    /**
     * 项目相关配置
     */
    private ProjectConfig projectConfig;
    /**
     * 应用信息配置
     */
    private ApplicationConfig applicationConfig;
    /**
     * 模块相关配置
     */
    private ModuleConfig moduleConfig;

    /**
     * 配置信息
     */
    protected BocpConfigBuilder bocpConfig;

    /**
     * 业务对象相关配置
     */
    private BoConfig boConfig;

    /**
     * 字典相关配置
     */
    private DictConfig dictConfig;

    /**
     * DTO相关配置
     */
    private DtoConfig dtoConfig;

    /**
     * 数据源配置
     */
    private DataSourceConfig dataSource;
    /**
     * 数据库表配置
     */
    private StrategyConfig strategy;
    /**
     * 包 相关配置
     */
    private PackageConfig packageInfo;

    /**
     * 全局 相关配置
     */
    private GlobalConfig globalConfig;

    /**
     * Bo模板引擎 - 实现的功能已经覆盖了原有的模板引擎
     */
    private BoVelocityTemplateEngine boTemplateEngine;
    /**
     * Application模板引擎
     */
    private ApplicationVelocityTemplateEngine appTemplateEngine;
    /**
     * Module模板引擎
     */
    private ModuleVelocityTemplateEngine moTemplateEngine;
    /**
     * Dict模板引擎
     */
    private DictVelocityTemplateEngine dictTemplateEngine;
    /**
     * Dto模板引擎
     */
    private DtoVelocityTemplateEngine dtoTemplateEngine;
    /**
     * 使用模板类型
     */
    private String engineType;

    /**
     * 生成代码
     */
    public void execute() {
        logger.debug("==========================准备生成文件...==========================");
        // 初始化配置
        if (null == bocpConfig) {
            bocpConfig = new BocpConfigBuilder(projectConfig, applicationConfig, moduleConfig, boConfig, dictConfig, dtoConfig, packageInfo, dataSource, strategy, template, globalConfig);
//            if (null != injectionConfig) {
//                injectionConfig.setConfig(bocpConfig);
//            }
        }
        Map<String, String> pathInfo = this.pretreatmentConfigBuilder(bocpConfig).getPathInfo();

        //不指定就默认使用原有的模板引擎
        if (engineType == null) {
            //清理上一次代码
            FileUtil.delAllFile(pathInfo.get(BocpConstVal.PARENT_POM_PATH));

            if (null == appTemplateEngine) {
                appTemplateEngine = new ApplicationVelocityTemplateEngine();
            }
            appTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================Application文件生成完成！！！==========================");
            if (null == moTemplateEngine) {
                moTemplateEngine = new ModuleVelocityTemplateEngine();
            }
            moTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================Module文件生成完成！！！==========================");
            if (null == boTemplateEngine) {
                boTemplateEngine = new BoVelocityTemplateEngine();
            }
            boTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================BO文件生成完成！！！==========================");
            if (null == dictTemplateEngine) {
                dictTemplateEngine = new DictVelocityTemplateEngine();
            }
            dictTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================Dict文件生成完成！！！==========================");
        }
        //application
        if (BocpConstVal.APPLICATIONENGINE.equals(engineType)) {
            //清理上一次代码
            FileUtil.delAllFile(pathInfo.get(BocpConstVal.PARENT_POM_PATH));

            if (null == appTemplateEngine) {
                appTemplateEngine = new ApplicationVelocityTemplateEngine();
            }
            appTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================Application文件生成完成！！！==========================");
        }
        //module
        if (BocpConstVal.MODULEENGINE.equals(engineType)) {
            //清理上一次代码
            FileUtil.delAllFile(pathInfo.get(BocpConstVal.MODULE_POM_PATH));

            if (null == moTemplateEngine) {
                moTemplateEngine = new ModuleVelocityTemplateEngine();
            }
            moTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================Module文件生成完成！！！==========================");
        }
        //bo
        if (BocpConstVal.BOENGINE.equals(engineType)) {
            if (null == boTemplateEngine) {
                boTemplateEngine = new BoVelocityTemplateEngine();
            }
            boTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================BO文件生成完成！！！==========================");
        }
        //dict
        if (BocpConstVal.DICTENGINE.equals(engineType)) {
            if (null == dictTemplateEngine) {
                dictTemplateEngine = new DictVelocityTemplateEngine();
            }
            dictTemplateEngine.init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug("==========================Dict文件生成完成！！！==========================");
        }
        //dto
        if(BocpConstVal.DTOENGINE.equals(engineType)) {
            if (null == dtoTemplateEngine) {
                dtoTemplateEngine = new DtoVelocityTemplateEngine();
            }
            dtoTemplateEngine
                    .init(this.pretreatmentConfigBuilder(bocpConfig))
                    .mkdirs()
                    .batchOutput()
                    .open();
            logger.debug("==========================Dto文件生成完成！！！==========================");
        }
    }

    /**
     * 开放表信息、预留子类重写
     *
     * @param bocpConfig 配置信息
     * @return ignore
     */
    protected List<TableInfo> getAllTableInfoList(BocpConfigBuilder bocpConfig) {
        return bocpConfig.getTableInfoList();
    }

    /**
     * 预处理配置
     *
     * @param bocpconfig 总配置信息
     * @return 解析数据结果集
     */
    protected BocpConfigBuilder pretreatmentConfigBuilder(BocpConfigBuilder bocpconfig) {
        /*
         * 表信息列表
         */
        List<TableInfo> tableList = this.getAllTableInfoList(bocpconfig);
        if(tableList != null) {
            for (TableInfo tableInfo : tableList) {
                /* ---------- 添加导入包 ---------- */
                if (bocpConfig.getGlobalConfig().isActiveRecord()) {
                    // 开启 ActiveRecord 模式
                    tableInfo.setImportPackages(Model.class.getCanonicalName());
                }
                if (tableInfo.isConvert()) {
                    // 表注解
                    tableInfo.setImportPackages(TableName.class.getCanonicalName());
                }
                if (bocpConfig.getStrategyConfig().getLogicDeleteFieldName() != null && tableInfo.isLogicDelete(bocpconfig.getStrategyConfig().getLogicDeleteFieldName())) {
                    // 逻辑删除注解
                    tableInfo.setImportPackages(TableLogic.class.getCanonicalName());
                }
                if (StringUtils.isNotEmpty(bocpconfig.getStrategyConfig().getVersionFieldName())) {
                    // 乐观锁注解
                    tableInfo.setImportPackages(Version.class.getCanonicalName());
                }
                boolean importSerializable = true;
                if (StringUtils.isNotEmpty(bocpconfig.getSuperEntityClass())) {
                    // 父实体
                    tableInfo.setImportPackages(bocpconfig.getSuperEntityClass());
                    importSerializable = false;
                }
                if (bocpconfig.getGlobalConfig().isActiveRecord()) {
                    importSerializable = true;
                }
                if (importSerializable) {
                    tableInfo.setImportPackages(Serializable.class.getCanonicalName());
                }
                // Boolean类型is前缀处理
                if (bocpconfig.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix()
                        && CollectionUtils.isNotEmpty(tableInfo.getFields())) {
                    tableInfo.getFields().stream().filter(field -> "boolean".equalsIgnoreCase(field.getPropertyType()))
                            .filter(field -> field.getPropertyName().startsWith("is"))
                            .forEach(field -> {
                                field.setConvert(true);
                                field.setPropertyName(StringUtils.removePrefixAfterPrefixToLower(field.getPropertyName(), 2));
                            });
                }
            }
        }
        return bocpconfig.setTableInfoList(tableList);
    }

    public BocpTemplateConfig getTemplate() {
        return template;
    }

    public void setTemplate(BocpTemplateConfig template) {
        this.template = template;
    }

    public ProjectConfig getProjectConfig() {
        return projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public ApplicationConfig getApplicationConfig() {
        return applicationConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public ModuleConfig getModuleConfig() {
        return moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public BocpConfigBuilder getBocpConfig() {
        return bocpConfig;
    }

    public void setBocpConfig(BocpConfigBuilder bocpConfig) {
        this.bocpConfig = bocpConfig;
    }

    public BoConfig getBoConfig() {
        return boConfig;
    }

    public void setBoConfig(BoConfig boConfig) {
        this.boConfig = boConfig;
    }

    public DataSourceConfig getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSourceConfig dataSource) {
        this.dataSource = dataSource;
    }

    public StrategyConfig getStrategy() {
        return strategy;
    }

    public void setStrategy(StrategyConfig strategy) {
        this.strategy = strategy;
    }

    public PackageConfig getPackageInfo() {
        return packageInfo;
    }

    public void setPackageInfo(PackageConfig packageInfo) {
        this.packageInfo = packageInfo;
    }

    public GlobalConfig getGlobalConfig() {
        return globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }
    public BoVelocityTemplateEngine getBoTemplateEngine() {
        return boTemplateEngine;
    }

    public void setBoTemplateEngine(BoVelocityTemplateEngine boTemplateEngine) {
        this.boTemplateEngine = boTemplateEngine;
    }

    public ApplicationVelocityTemplateEngine getAppTemplateEngine() {
        return appTemplateEngine;
    }

    public void setAppTemplateEngine(ApplicationVelocityTemplateEngine appTemplateEngine) {
        this.appTemplateEngine = appTemplateEngine;
    }

    public ModuleVelocityTemplateEngine getMoTemplateEngine() {
        return moTemplateEngine;
    }

    public void setMoTemplateEngine(ModuleVelocityTemplateEngine moTemplateEngine) {
        this.moTemplateEngine = moTemplateEngine;
    }

    public String getEngineType() {
        return engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public DictConfig getDictConfig() {
        return dictConfig;
    }

    public void setDictConfig(DictConfig dictConfig) {
        this.dictConfig = dictConfig;
    }

    public DtoConfig getDtoConfig() {
        return dtoConfig;
    }

    public void setDtoConfig(DtoConfig dtoConfig) {
        this.dtoConfig = dtoConfig;
    }
}
